/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.io.File;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.TypeShedPythonFile;

public class SymbolUtils {
    private SymbolUtils() {
    }

    public static String getModuleFileName(String fileName) {
        int extensionIndex = fileName.lastIndexOf(46);
        return extensionIndex > 0 ? fileName.substring(0, extensionIndex) : fileName;
    }

    public static String fullyQualifiedModuleName(String packageName, String fileName) {
        String moduleName = SymbolUtils.getModuleFileName(fileName);
        if (moduleName.equals("__init__")) {
            return packageName;
        }
        return packageName.isEmpty() ? moduleName : packageName + "." + moduleName;
    }

    static void resolveTypeHierarchy(ClassDef classDef, @Nullable Symbol symbol, PythonFile pythonFile, Map<String, Symbol> symbolsByName) {
        if (symbol == null || !Symbol.Kind.CLASS.equals((Object)symbol.kind())) {
            return;
        }
        ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
        if (SymbolUtils.isBuiltinTypeshedFile(pythonFile) && "str".equals(classSymbol.fullyQualifiedName())) {
            classSymbol.addSuperClass(symbolsByName.get("object"));
            classSymbol.addSuperClass(symbolsByName.get("Sequence"));
            return;
        }
        ArgList argList = classDef.args();
        if (argList == null) {
            return;
        }
        for (Argument argument : argList.arguments()) {
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT)) {
                classSymbol.setHasSuperClassWithoutSymbol();
                continue;
            }
            SymbolUtils.addParentClass(pythonFile, symbolsByName, classSymbol, (RegularArgument)argument);
        }
    }

    private static void addParentClass(PythonFile pythonFile, Map<String, Symbol> symbolsByName, ClassSymbolImpl classSymbol, RegularArgument regularArgument) {
        Name keyword = regularArgument.keywordArgument();
        if (keyword != null) {
            if (keyword.name().equals("metaclass")) {
                classSymbol.setHasMetaClass();
                TreeUtils.getSymbolFromTree(regularArgument.expression()).map(Symbol::fullyQualifiedName).ifPresent(classSymbol::setMetaclassFQN);
            }
            return;
        }
        Symbol argumentSymbol = SymbolUtils.getSymbolFromArgument(regularArgument);
        if (argumentSymbol == null) {
            classSymbol.setHasSuperClassWithoutSymbol();
        } else {
            Symbol normalizedArgumentSymbol;
            if ("typing.Generic".equals(argumentSymbol.fullyQualifiedName())) {
                classSymbol.setSupportsGenerics(true);
            }
            if ((normalizedArgumentSymbol = SymbolUtils.normalizeSymbol(argumentSymbol, pythonFile, symbolsByName)) != null) {
                classSymbol.addSuperClass(normalizedArgumentSymbol);
            }
        }
    }

    @CheckForNull
    private static Symbol normalizeSymbol(Symbol symbol, PythonFile pythonFile, Map<String, Symbol> symbolsByName) {
        if (SymbolUtils.isTypeShedFile(pythonFile) && (symbol.name().equals("Protocol") || symbol.name().equals("Generic"))) {
            return null;
        }
        if (SymbolUtils.isTypingFile(pythonFile) && symbol.name().equals("_Collection")) {
            return symbolsByName.get("Collection");
        }
        return symbol;
    }

    private static boolean isBuiltinTypeshedFile(PythonFile pythonFile) {
        return SymbolUtils.isTypeShedFile(pythonFile) && pythonFile.fileName().isEmpty();
    }

    private static boolean isTypingFile(PythonFile pythonFile) {
        return SymbolUtils.isTypeShedFile(pythonFile) && pythonFile.fileName().equals("typing");
    }

    @CheckForNull
    private static Symbol getSymbolFromArgument(RegularArgument regularArgument) {
        Expression expression = regularArgument.expression();
        while (expression.is(Tree.Kind.SUBSCRIPTION)) {
            expression = ((SubscriptionExpression)expression).object();
        }
        if (expression instanceof HasSymbol) {
            return ((HasSymbol)((Object)expression)).symbol();
        }
        return null;
    }

    public static List<Expression> assignmentsLhs(AssignmentStatement assignmentStatement) {
        return assignmentStatement.lhsExpressions().stream().flatMap(exprList -> exprList.expressions().stream()).flatMap(TreeUtils::flattenTuples).collect(Collectors.toList());
    }

    static List<Name> boundNamesFromExpression(@CheckForNull Tree tree) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (tree == null) {
            return names;
        }
        if (tree.is(Tree.Kind.NAME)) {
            names.add((Name)tree);
        } else if (tree.is(Tree.Kind.TUPLE)) {
            ((Tuple)tree).elements().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.LIST_LITERAL)) {
            ((ListLiteral)tree).elements().expressions().forEach(t -> names.addAll(SymbolUtils.boundNamesFromExpression(t)));
        } else if (tree.is(Tree.Kind.PARENTHESIZED)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((ParenthesizedExpression)tree).expression()));
        } else if (tree.is(Tree.Kind.UNPACKING_EXPR)) {
            names.addAll(SymbolUtils.boundNamesFromExpression(((UnpackingExpression)tree).expression()));
        }
        return names;
    }

    public static String pythonPackageName(File file, String projectBaseDirAbsolutePath) {
        File initFile;
        File currentDirectory = file.getParentFile();
        ArrayDeque<String> packages = new ArrayDeque<String>();
        while (!currentDirectory.getAbsolutePath().equals(projectBaseDirAbsolutePath) && (initFile = new File(currentDirectory, "__init__.py")).exists()) {
            packages.push(currentDirectory.getName());
            currentDirectory = currentDirectory.getParentFile();
        }
        return String.join((CharSequence)".", packages);
    }

    @CheckForNull
    public static Path pathOf(PythonFile pythonFile) {
        try {
            URI uri = pythonFile.uri();
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return Paths.get(uri);
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public static boolean isTypeShedFile(PythonFile pythonFile) {
        return pythonFile instanceof TypeShedPythonFile;
    }

    public static int firstParameterOffset(FunctionSymbol functionSymbol, boolean isStaticCall) {
        List<FunctionSymbol.Parameter> parameters = functionSymbol.parameters();
        if (parameters.isEmpty()) {
            return 0;
        }
        String firstParamName = parameters.get(0).name();
        if (firstParamName == null) {
            return -1;
        }
        List<String> decoratorNames = functionSymbol.decorators();
        if (decoratorNames.size() > 1) {
            return -1;
        }
        if (!(decoratorNames.isEmpty() || decoratorNames.get(0).endsWith("classmethod") || decoratorNames.get(0).endsWith("staticmethod"))) {
            return -1;
        }
        if (functionSymbol.isInstanceMethod() && !isStaticCall) {
            return 1;
        }
        if (decoratorNames.size() == 1 && decoratorNames.get(0).endsWith("classmethod")) {
            return 1;
        }
        return 0;
    }

    public static Optional<FunctionSymbol> getOverriddenMethod(FunctionSymbol functionSymbol) {
        Symbol owner = ((FunctionSymbolImpl)functionSymbol).owner();
        if (owner == null || owner.kind() != Symbol.Kind.CLASS) {
            return Optional.empty();
        }
        ClassSymbol classSymbol = (ClassSymbol)owner;
        if (classSymbol.superClasses().isEmpty()) {
            return Optional.empty();
        }
        for (Symbol superClass : classSymbol.superClasses()) {
            if (superClass.kind() != Symbol.Kind.CLASS) continue;
            Optional<FunctionSymbol> overriddenSymbol = ((ClassSymbol)superClass).resolveMember(functionSymbol.name()).filter(symbol -> symbol.kind() == Symbol.Kind.FUNCTION).map(FunctionSymbol.class::cast);
            if (!overriddenSymbol.isPresent()) continue;
            return overriddenSymbol;
        }
        return Optional.empty();
    }

    public static Symbol typeshedSymbolWithFQN(String fullyQualifiedName) {
        String[] fqnSplitByDot = fullyQualifiedName.split("\\.");
        String localName = fqnSplitByDot[fqnSplitByDot.length - 1];
        Symbol symbol = TypeShed.symbolWithFQN(fullyQualifiedName);
        return symbol == null ? new SymbolImpl(localName, fullyQualifiedName) : ((SymbolImpl)symbol).copyWithoutUsages();
    }

    public static Set<Symbol> flattenAmbiguousSymbols(Set<Symbol> symbols) {
        HashSet<Symbol> alternatives = new HashSet<Symbol>();
        for (Symbol symbol : symbols) {
            if (symbol.is(Symbol.Kind.AMBIGUOUS)) {
                Set<Symbol> flattenedAlternatives = SymbolUtils.flattenAmbiguousSymbols(((AmbiguousSymbol)symbol).alternatives());
                alternatives.addAll(flattenedAlternatives);
                continue;
            }
            alternatives.add(symbol);
        }
        return alternatives;
    }

    public static boolean isPrivateName(String name) {
        return name.startsWith("_") && !name.startsWith("__");
    }
}

