/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayList;
import java.util.List;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonFile;
import org.sonar.python.api.tree.PyFileInputTree;
import org.sonar.python.semantic.SymbolTable;
import org.sonar.python.semantic.SymbolTableBuilderVisitor;
import org.sonar.python.tree.PyFileInputTreeImpl;

public class PythonVisitorContext {
    private final PyFileInputTreeImpl rootTree;
    private final PythonFile pythonFile;
    private final RecognitionException parsingException;
    private final AstNode rootAst;
    private SymbolTable symbolTable = null;
    private List<PythonCheck.PreciseIssue> issues = new ArrayList<PythonCheck.PreciseIssue>();

    public PythonVisitorContext(AstNode rootAst, PyFileInputTree rootTree, PythonFile pythonFile) {
        this(rootAst, rootTree, pythonFile, null);
        SymbolTableBuilderVisitor symbolTableBuilderVisitor = new SymbolTableBuilderVisitor();
        symbolTableBuilderVisitor.scanFile(this);
        this.symbolTable = symbolTableBuilderVisitor.symbolTable();
    }

    public PythonVisitorContext(PythonFile pythonFile, RecognitionException parsingException) {
        this(null, null, pythonFile, parsingException);
    }

    private PythonVisitorContext(AstNode rootAst, PyFileInputTree rootTree, PythonFile pythonFile, RecognitionException parsingException) {
        this.rootAst = rootAst;
        this.rootTree = (PyFileInputTreeImpl)rootTree;
        this.pythonFile = pythonFile;
        this.parsingException = parsingException;
    }

    public PyFileInputTree rootTree() {
        return this.rootTree;
    }

    public AstNode rootAstNode() {
        return this.rootAst;
    }

    public PythonFile pythonFile() {
        return this.pythonFile;
    }

    public RecognitionException parsingException() {
        return this.parsingException;
    }

    public SymbolTable symbolTable() {
        return this.symbolTable;
    }

    public void addIssue(PythonCheck.PreciseIssue issue) {
        this.issues.add(issue);
    }

    public List<PythonCheck.PreciseIssue> getIssues() {
        return this.issues;
    }
}

