/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.python.PythonVisitor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;

public class ComplexityVisitor
extends PythonVisitor {
    private int complexity;

    public static int complexity(AstNode node) {
        ComplexityVisitor visitor = node.is(new AstNodeType[]{PythonGrammar.FUNCDEF}) ? new FunctionComplexityVisitor() : new ComplexityVisitor();
        visitor.scanNode(node);
        return visitor.complexity;
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        HashSet<Enum> set = new HashSet<Enum>();
        set.add(PythonGrammar.FUNCDEF);
        set.add(PythonGrammar.FOR_STMT);
        set.add(PythonGrammar.WHILE_STMT);
        set.add(PythonKeyword.IF);
        set.add(PythonKeyword.AND);
        set.add(PythonKeyword.OR);
        return Collections.unmodifiableSet(set);
    }

    @Override
    public void visitFile(AstNode node) {
        this.complexity = 0;
    }

    @Override
    public void visitNode(AstNode node) {
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    private static class FunctionComplexityVisitor
    extends ComplexityVisitor {
        private int functionNestingLevel = 0;

        private FunctionComplexityVisitor() {
        }

        @Override
        public void visitNode(AstNode node) {
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                ++this.functionNestingLevel;
            }
            if (this.functionNestingLevel == 1) {
                super.visitNode(node);
            }
        }

        @Override
        public void leaveNode(AstNode node) {
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                --this.functionNestingLevel;
            }
        }
    }
}

