/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.metrics.CognitiveComplexityVisitor;
import org.sonar.python.metrics.ComplexityVisitor;
import org.sonar.python.metrics.FileLinesVisitor;

public class FileMetrics {
    private int numberOfStatements;
    private int numberOfClasses;
    private final ComplexityVisitor complexityVisitor = new ComplexityVisitor();
    private final CognitiveComplexityVisitor cognitiveComplexityVisitor = new CognitiveComplexityVisitor(null);
    private final FileLinesVisitor fileLinesVisitor;
    private List<Integer> functionComplexities = new ArrayList<Integer>();

    public FileMetrics(PythonVisitorContext context, boolean ignoreHeaderComments) {
        AstNode rootTree = context.rootAstNode();
        this.numberOfStatements = rootTree.getDescendants(new AstNodeType[]{PythonGrammar.STATEMENT}).size();
        this.numberOfClasses = rootTree.getDescendants(new AstNodeType[]{PythonGrammar.CLASSDEF}).size();
        this.complexityVisitor.scanFile(context);
        context.rootTree().accept(this.cognitiveComplexityVisitor);
        this.fileLinesVisitor = new FileLinesVisitor(ignoreHeaderComments);
        this.fileLinesVisitor.scanFile(context);
        for (AstNode functionDef : rootTree.getDescendants(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            this.functionComplexities.add(ComplexityVisitor.complexity(functionDef));
        }
    }

    public int numberOfStatements() {
        return this.numberOfStatements;
    }

    public int numberOfFunctions() {
        return this.functionComplexities.size();
    }

    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    public int complexity() {
        return this.complexityVisitor.getComplexity();
    }

    public int cognitiveComplexity() {
        return this.cognitiveComplexityVisitor.getComplexity();
    }

    public List<Integer> functionComplexities() {
        return this.functionComplexities;
    }

    public FileLinesVisitor fileLinesVisitor() {
        return this.fileLinesVisitor;
    }
}

