/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyAliasedNameTree;
import org.sonar.python.api.tree.PyAnnotatedAssignmentTree;
import org.sonar.python.api.tree.PyArgListTree;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyAssertStatementTree;
import org.sonar.python.api.tree.PyAssignmentStatementTree;
import org.sonar.python.api.tree.PyAwaitExpressionTree;
import org.sonar.python.api.tree.PyBinaryExpressionTree;
import org.sonar.python.api.tree.PyBreakStatementTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyClassDefTree;
import org.sonar.python.api.tree.PyCompoundAssignmentStatementTree;
import org.sonar.python.api.tree.PyComprehensionExpressionTree;
import org.sonar.python.api.tree.PyComprehensionForTree;
import org.sonar.python.api.tree.PyComprehensionIfTree;
import org.sonar.python.api.tree.PyConditionalExpressionTree;
import org.sonar.python.api.tree.PyContinueStatementTree;
import org.sonar.python.api.tree.PyDecoratorTree;
import org.sonar.python.api.tree.PyDelStatementTree;
import org.sonar.python.api.tree.PyDictionaryLiteralTree;
import org.sonar.python.api.tree.PyDottedNameTree;
import org.sonar.python.api.tree.PyEllipsisExpressionTree;
import org.sonar.python.api.tree.PyElseStatementTree;
import org.sonar.python.api.tree.PyExceptClauseTree;
import org.sonar.python.api.tree.PyExecStatementTree;
import org.sonar.python.api.tree.PyExpressionListTree;
import org.sonar.python.api.tree.PyExpressionStatementTree;
import org.sonar.python.api.tree.PyFileInputTree;
import org.sonar.python.api.tree.PyFinallyClauseTree;
import org.sonar.python.api.tree.PyForStatementTree;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyGlobalStatementTree;
import org.sonar.python.api.tree.PyIfStatementTree;
import org.sonar.python.api.tree.PyImportFromTree;
import org.sonar.python.api.tree.PyImportNameTree;
import org.sonar.python.api.tree.PyKeyValuePairTree;
import org.sonar.python.api.tree.PyLambdaExpressionTree;
import org.sonar.python.api.tree.PyListLiteralTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyNoneExpressionTree;
import org.sonar.python.api.tree.PyNonlocalStatementTree;
import org.sonar.python.api.tree.PyNumericLiteralTree;
import org.sonar.python.api.tree.PyParameterListTree;
import org.sonar.python.api.tree.PyParameterTree;
import org.sonar.python.api.tree.PyParenthesizedExpressionTree;
import org.sonar.python.api.tree.PyPassStatementTree;
import org.sonar.python.api.tree.PyPrintStatementTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.PyRaiseStatementTree;
import org.sonar.python.api.tree.PyReprExpressionTree;
import org.sonar.python.api.tree.PyReturnStatementTree;
import org.sonar.python.api.tree.PySetLiteralTree;
import org.sonar.python.api.tree.PySliceExpressionTree;
import org.sonar.python.api.tree.PySliceItemTree;
import org.sonar.python.api.tree.PySliceListTree;
import org.sonar.python.api.tree.PyStarredExpressionTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyStringElementTree;
import org.sonar.python.api.tree.PyStringLiteralTree;
import org.sonar.python.api.tree.PySubscriptionExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyTryStatementTree;
import org.sonar.python.api.tree.PyTupleParameterTree;
import org.sonar.python.api.tree.PyTupleTree;
import org.sonar.python.api.tree.PyTypeAnnotationTree;
import org.sonar.python.api.tree.PyUnaryExpressionTree;
import org.sonar.python.api.tree.PyWhileStatementTree;
import org.sonar.python.api.tree.PyWithItemTree;
import org.sonar.python.api.tree.PyWithStatementTree;
import org.sonar.python.api.tree.PyYieldExpressionTree;
import org.sonar.python.api.tree.PyYieldStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyDictCompExpressionTreeImpl;

public class BaseTreeVisitor
implements PyTreeVisitor {
    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected void scan(List<? extends Tree> trees) {
        if (trees != null) {
            for (Tree tree : trees) {
                this.scan(tree);
            }
        }
    }

    @Override
    public void visitFileInput(PyFileInputTree pyFileInputTree) {
        this.scan(pyFileInputTree.statements());
    }

    @Override
    public void visitStatementList(PyStatementListTree pyStatementListTree) {
        this.scan(pyStatementListTree.statements());
    }

    @Override
    public void visitIfStatement(PyIfStatementTree pyIfStatementTree) {
        this.scan(pyIfStatementTree.condition());
        this.scan(pyIfStatementTree.body());
        this.scan(pyIfStatementTree.elifBranches());
        this.scan(pyIfStatementTree.elseBranch());
    }

    @Override
    public void visitElseStatement(PyElseStatementTree pyElseStatementTree) {
        this.scan(pyElseStatementTree.body());
    }

    @Override
    public void visitExecStatement(PyExecStatementTree pyExecStatementTree) {
        this.scan(pyExecStatementTree.expression());
        this.scan(pyExecStatementTree.globalsExpression());
        this.scan(pyExecStatementTree.localsExpression());
    }

    @Override
    public void visitAssertStatement(PyAssertStatementTree pyAssertStatementTree) {
        this.scan(pyAssertStatementTree.expressions());
    }

    @Override
    public void visitDelStatement(PyDelStatementTree pyDelStatementTree) {
        this.scan(pyDelStatementTree.expressions());
    }

    @Override
    public void visitPassStatement(PyPassStatementTree pyPassStatementTree) {
    }

    @Override
    public void visitPrintStatement(PyPrintStatementTree pyPrintStatementTree) {
        this.scan(pyPrintStatementTree.expressions());
    }

    @Override
    public void visitReturnStatement(PyReturnStatementTree pyReturnStatementTree) {
        this.scan(pyReturnStatementTree.expressions());
    }

    @Override
    public void visitYieldStatement(PyYieldStatementTree pyYieldStatementTree) {
        this.scan(pyYieldStatementTree.yieldExpression());
    }

    @Override
    public void visitYieldExpression(PyYieldExpressionTree pyYieldExpressionTree) {
        this.scan(pyYieldExpressionTree.expressions());
    }

    @Override
    public void visitRaiseStatement(PyRaiseStatementTree pyRaiseStatementTree) {
        this.scan(pyRaiseStatementTree.expressions());
        this.scan(pyRaiseStatementTree.fromExpression());
    }

    @Override
    public void visitBreakStatement(PyBreakStatementTree pyBreakStatementTree) {
    }

    @Override
    public void visitContinueStatement(PyContinueStatementTree pyContinueStatementTree) {
    }

    @Override
    public void visitFunctionDef(PyFunctionDefTree pyFunctionDefTree) {
        this.scan(pyFunctionDefTree.decorators());
        this.scan(pyFunctionDefTree.name());
        this.scan(pyFunctionDefTree.parameters());
        this.scan(pyFunctionDefTree.returnTypeAnnotation());
        this.scan(pyFunctionDefTree.body());
    }

    @Override
    public void visitName(PyNameTree pyNameTree) {
    }

    @Override
    public void visitClassDef(PyClassDefTree pyClassDefTree) {
        this.scan(pyClassDefTree.name());
        this.scan(pyClassDefTree.args());
        this.scan(pyClassDefTree.body());
    }

    @Override
    public void visitAliasedName(PyAliasedNameTree pyAliasedNameTree) {
        this.scan(pyAliasedNameTree.dottedName());
        this.scan(pyAliasedNameTree.alias());
    }

    @Override
    public void visitDottedName(PyDottedNameTree pyDottedNameTree) {
        this.scan(pyDottedNameTree.names());
    }

    @Override
    public void visitImportFrom(PyImportFromTree pyImportFromTree) {
        this.scan(pyImportFromTree.module());
        this.scan(pyImportFromTree.importedNames());
    }

    @Override
    public void visitForStatement(PyForStatementTree pyForStatementTree) {
        this.scan(pyForStatementTree.expressions());
        this.scan(pyForStatementTree.testExpressions());
        this.scan(pyForStatementTree.body());
        this.scan(pyForStatementTree.elseBody());
    }

    @Override
    public void visitImportName(PyImportNameTree pyImportNameTree) {
        this.scan(pyImportNameTree.modules());
    }

    @Override
    public void visitGlobalStatement(PyGlobalStatementTree pyGlobalStatementTree) {
        this.scan(pyGlobalStatementTree.variables());
    }

    @Override
    public void visitNonlocalStatement(PyNonlocalStatementTree pyNonlocalStatementTree) {
        this.scan(pyNonlocalStatementTree.variables());
    }

    @Override
    public void visitWhileStatement(PyWhileStatementTree pyWhileStatementTree) {
        this.scan(pyWhileStatementTree.condition());
        this.scan(pyWhileStatementTree.body());
        this.scan(pyWhileStatementTree.elseBody());
    }

    @Override
    public void visitExpressionStatement(PyExpressionStatementTree pyExpressionStatementTree) {
        this.scan(pyExpressionStatementTree.expressions());
    }

    @Override
    public void visitTryStatement(PyTryStatementTree pyTryStatementTree) {
        this.scan(pyTryStatementTree.body());
        this.scan(pyTryStatementTree.exceptClauses());
        this.scan(pyTryStatementTree.finallyClause());
        this.scan(pyTryStatementTree.elseClause());
    }

    @Override
    public void visitFinallyClause(PyFinallyClauseTree pyFinallyClauseTree) {
        this.scan(pyFinallyClauseTree.body());
    }

    @Override
    public void visitExceptClause(PyExceptClauseTree pyExceptClauseTree) {
        this.scan(pyExceptClauseTree.exception());
        this.scan(pyExceptClauseTree.exceptionInstance());
        this.scan(pyExceptClauseTree.body());
    }

    @Override
    public void visitWithStatement(PyWithStatementTree pyWithStatementTree) {
        this.scan(pyWithStatementTree.withItems());
        this.scan(pyWithStatementTree.statements());
    }

    @Override
    public void visitWithItem(PyWithItemTree pyWithItemTree) {
        this.scan(pyWithItemTree.test());
        this.scan(pyWithItemTree.expression());
    }

    @Override
    public void visitQualifiedExpression(PyQualifiedExpressionTree pyQualifiedExpressionTree) {
        this.scan(pyQualifiedExpressionTree.qualifier());
        this.scan(pyQualifiedExpressionTree.name());
    }

    @Override
    public void visitCallExpression(PyCallExpressionTree pyCallExpressionTree) {
        this.scan(pyCallExpressionTree.callee());
        this.scan(pyCallExpressionTree.argumentList());
    }

    @Override
    public void visitArgumentList(PyArgListTree pyArgListTree) {
        this.scan(pyArgListTree.arguments());
    }

    @Override
    public void visitArgument(PyArgumentTree pyArgumentTree) {
        this.scan(pyArgumentTree.keywordArgument());
        this.scan(pyArgumentTree.expression());
    }

    @Override
    public void visitAssignmentStatement(PyAssignmentStatementTree pyAssignmentStatementTree) {
        this.scan(pyAssignmentStatementTree.lhsExpressions());
        this.scan(pyAssignmentStatementTree.assignedValue());
    }

    @Override
    public void visitExpressionList(PyExpressionListTree pyExpressionListTree) {
        this.scan(pyExpressionListTree.expressions());
    }

    @Override
    public void visitBinaryExpression(PyBinaryExpressionTree pyBinaryExpressionTree) {
        this.scan(pyBinaryExpressionTree.leftOperand());
        this.scan(pyBinaryExpressionTree.rightOperand());
    }

    @Override
    public void visitLambda(PyLambdaExpressionTree pyLambdaExpressionTree) {
        this.scan(pyLambdaExpressionTree.parameters());
        this.scan(pyLambdaExpressionTree.expression());
    }

    @Override
    public void visitParameterList(PyParameterListTree pyParameterListTree) {
        this.scan(pyParameterListTree.all());
    }

    @Override
    public void visitTupleParameter(PyTupleParameterTree tree) {
        this.scan(tree.parameters());
    }

    @Override
    public void visitParameter(PyParameterTree tree) {
        this.scan(tree.name());
        this.scan(tree.typeAnnotation());
        this.scan(tree.defaultValue());
    }

    @Override
    public void visitTypeAnnotation(PyTypeAnnotationTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitNumericLiteral(PyNumericLiteralTree pyNumericLiteralTree) {
    }

    @Override
    public void visitStringLiteral(PyStringLiteralTree pyStringLiteralTree) {
        this.scan(pyStringLiteralTree.stringElements());
    }

    @Override
    public void visitStringElement(PyStringElementTree tree) {
    }

    @Override
    public void visitListLiteral(PyListLiteralTree pyListLiteralTree) {
        this.scan(pyListLiteralTree.elements());
    }

    @Override
    public void visitUnaryExpression(PyUnaryExpressionTree pyUnaryExpressionTree) {
        this.scan(pyUnaryExpressionTree.expression());
    }

    @Override
    public void visitStarredExpression(PyStarredExpressionTree pyStarredExpressionTree) {
        this.scan(pyStarredExpressionTree.expression());
    }

    @Override
    public void visitAwaitExpression(PyAwaitExpressionTree pyAwaitExpressionTree) {
        this.scan(pyAwaitExpressionTree.expression());
    }

    @Override
    public void visitSliceExpression(PySliceExpressionTree pySliceExpressionTree) {
        this.scan(pySliceExpressionTree.object());
        this.scan(pySliceExpressionTree.sliceList());
    }

    @Override
    public void visitSliceList(PySliceListTree pySliceListTree) {
        this.scan(pySliceListTree.slices());
    }

    @Override
    public void visitSliceItem(PySliceItemTree pySliceItemTree) {
        this.scan(pySliceItemTree.lowerBound());
        this.scan(pySliceItemTree.upperBound());
        this.scan(pySliceItemTree.stride());
    }

    @Override
    public void visitSubscriptionExpression(PySubscriptionExpressionTree pySubscriptionExpressionTree) {
        this.scan(pySubscriptionExpressionTree.object());
        this.scan(pySubscriptionExpressionTree.subscripts());
    }

    @Override
    public void visitParenthesizedExpression(PyParenthesizedExpressionTree pyParenthesizedExpressionTree) {
        this.scan(pyParenthesizedExpressionTree.expression());
    }

    @Override
    public void visitTuple(PyTupleTree pyTupleTree) {
        this.scan(pyTupleTree.elements());
    }

    @Override
    public void visitConditionalExpression(PyConditionalExpressionTree pyConditionalExpressionTree) {
        this.scan(pyConditionalExpressionTree.condition());
        this.scan(pyConditionalExpressionTree.trueExpression());
        this.scan(pyConditionalExpressionTree.falseExpression());
    }

    @Override
    public void visitPyListOrSetCompExpression(PyComprehensionExpressionTree tree) {
        this.scan(tree.resultExpression());
        this.scan(tree.comprehensionFor());
    }

    @Override
    public void visitComprehensionFor(PyComprehensionForTree tree) {
        this.scan(tree.loopExpression());
        this.scan(tree.iterable());
        this.scan(tree.nestedClause());
    }

    @Override
    public void visitComprehensionIf(PyComprehensionIfTree tree) {
        this.scan(tree.condition());
        this.scan(tree.nestedClause());
    }

    @Override
    public void visitDictionaryLiteral(PyDictionaryLiteralTree pyDictionaryLiteralTree) {
        this.scan(pyDictionaryLiteralTree.elements());
    }

    @Override
    public void visitSetLiteral(PySetLiteralTree pySetLiteralTree) {
        this.scan(pySetLiteralTree.elements());
    }

    @Override
    public void visitKeyValuePair(PyKeyValuePairTree pyKeyValuePairTree) {
        this.scan(pyKeyValuePairTree.expression());
        this.scan(pyKeyValuePairTree.key());
        this.scan(pyKeyValuePairTree.value());
    }

    @Override
    public void visitDictCompExpression(PyDictCompExpressionTreeImpl tree) {
        this.scan(tree.keyExpression());
        this.scan(tree.valueExpression());
        this.scan(tree.comprehensionFor());
    }

    @Override
    public void visitCompoundAssignment(PyCompoundAssignmentStatementTree pyCompoundAssignmentStatementTree) {
        this.scan(pyCompoundAssignmentStatementTree.lhsExpression());
        this.scan(pyCompoundAssignmentStatementTree.rhsExpression());
    }

    @Override
    public void visitAnnotatedAssignment(PyAnnotatedAssignmentTree pyAnnotatedAssignmentTree) {
        this.scan(pyAnnotatedAssignmentTree.variable());
        this.scan(pyAnnotatedAssignmentTree.annotation());
        this.scan(pyAnnotatedAssignmentTree.assignedValue());
    }

    @Override
    public void visitNone(PyNoneExpressionTree pyNoneExpressionTree) {
    }

    @Override
    public void visitRepr(PyReprExpressionTree pyReprExpressionTree) {
        this.scan(pyReprExpressionTree.expressionList());
    }

    @Override
    public void visitEllipsis(PyEllipsisExpressionTree pyEllipsisExpressionTree) {
    }

    @Override
    public void visitDecorator(PyDecoratorTree pyDecoratorTree) {
        this.scan(pyDecoratorTree.name());
        this.scan(pyDecoratorTree.arguments());
    }
}

