/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.PyAssignmentStatementTree;
import org.sonar.python.api.tree.PyExpressionListTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyAssignmentStatementTreeImpl
extends PyTree
implements PyAssignmentStatementTree {
    private final List<Token> assignTokens;
    private final List<PyExpressionListTree> lhsExpressions;
    private final PyExpressionTree assignedValue;

    public PyAssignmentStatementTreeImpl(AstNode astNode, List<Token> assignTokens, List<PyExpressionListTree> lhsExpressions, PyExpressionTree assignedValue) {
        super(astNode);
        this.assignTokens = assignTokens;
        this.lhsExpressions = lhsExpressions;
        this.assignedValue = assignedValue;
    }

    @Override
    public PyExpressionTree assignedValue() {
        return this.assignedValue;
    }

    @Override
    public List<Token> equalTokens() {
        return this.assignTokens;
    }

    @Override
    public List<PyExpressionListTree> lhsExpressions() {
        return this.lhsExpressions;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitAssignmentStatement(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ASSIGNMENT_STMT;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.lhsExpressions, Collections.singletonList(this.assignedValue)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

