/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyArgListTree;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyCallExpressionTreeImpl
extends PyTree
implements PyCallExpressionTree {
    private final PyExpressionTree callee;
    private final PyArgListTree argumentList;
    private final Token leftPar;
    private final Token rightPar;

    public PyCallExpressionTreeImpl(AstNode astNode, PyExpressionTree callee, @Nullable PyArgListTree argumentList, AstNode leftPar, AstNode rightPar) {
        super(astNode);
        this.callee = callee;
        this.argumentList = argumentList;
        this.leftPar = leftPar.getToken();
        this.rightPar = rightPar.getToken();
    }

    public PyCallExpressionTreeImpl(PyExpressionTree callee, @Nullable PyArgListTree argumentList, AstNode leftPar, AstNode rightPar) {
        super(callee.firstToken(), rightPar.getToken());
        this.callee = callee;
        this.argumentList = argumentList;
        this.leftPar = leftPar.getToken();
        this.rightPar = rightPar.getToken();
    }

    @Override
    public PyExpressionTree callee() {
        return this.callee;
    }

    @Override
    public PyArgListTree argumentList() {
        return this.argumentList;
    }

    @Override
    public List<PyArgumentTree> arguments() {
        return this.argumentList != null ? this.argumentList.arguments() : Collections.emptyList();
    }

    @Override
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CALL_EXPR;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.callee, this.argumentList);
    }
}

