/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import org.sonar.python.api.tree.PyConditionalExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyConditionalExpressionTreeImpl
extends PyTree
implements PyConditionalExpressionTree {
    private final PyExpressionTree trueExpression;
    private final Token ifToken;
    private final PyExpressionTree condition;
    private final Token elseToken;
    private final PyExpressionTree falseExpression;

    public PyConditionalExpressionTreeImpl(AstNode node, PyExpressionTree trueExpression, Token ifToken, PyExpressionTree condition, Token elseToken, PyExpressionTree falseExpression) {
        super(node);
        this.trueExpression = trueExpression;
        this.ifToken = ifToken;
        this.condition = condition;
        this.elseToken = elseToken;
        this.falseExpression = falseExpression;
    }

    @Override
    public Token ifKeyword() {
        return this.ifToken;
    }

    @Override
    public Token elseKeyword() {
        return this.elseToken;
    }

    @Override
    public PyExpressionTree trueExpression() {
        return this.trueExpression;
    }

    @Override
    public PyExpressionTree falseExpression() {
        return this.falseExpression;
    }

    @Override
    public PyExpressionTree condition() {
        return this.condition;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.condition, this.trueExpression, this.falseExpression);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPR;
    }
}

