/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExceptClauseTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyExceptClauseTreeImpl
extends PyTree
implements PyExceptClauseTree {
    private final Token exceptKeyword;
    private final PyStatementListTree body;
    private final PyExpressionTree exception;
    private final Token asKeyword;
    private final Token commaToken;
    private final PyExpressionTree exceptionInstance;

    public PyExceptClauseTreeImpl(Token exceptKeyword, PyStatementListTree body) {
        super(exceptKeyword, body.lastToken());
        this.exceptKeyword = exceptKeyword;
        this.body = body;
        this.exception = null;
        this.asKeyword = null;
        this.commaToken = null;
        this.exceptionInstance = null;
    }

    public PyExceptClauseTreeImpl(Token exceptKeyword, PyStatementListTree body, PyExpressionTree exception, @Nullable AstNode asNode, @Nullable AstNode commaNode, PyExpressionTree exceptionInstance) {
        super(exceptKeyword, body.lastToken());
        this.exceptKeyword = exceptKeyword;
        this.body = body;
        this.exception = exception;
        this.asKeyword = asNode != null ? asNode.getToken() : null;
        this.commaToken = commaNode != null ? commaNode.getToken() : null;
        this.exceptionInstance = exceptionInstance;
    }

    public PyExceptClauseTreeImpl(Token exceptKeyword, PyStatementListTree body, PyExpressionTree exception) {
        super(exceptKeyword, body.lastToken());
        this.exceptKeyword = exceptKeyword;
        this.body = body;
        this.exception = exception;
        this.asKeyword = null;
        this.commaToken = null;
        this.exceptionInstance = null;
    }

    @Override
    public Token exceptKeyword() {
        return this.exceptKeyword;
    }

    @Override
    public PyStatementListTree body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token asKeyword() {
        return this.asKeyword;
    }

    @Override
    @CheckForNull
    public Token commaToken() {
        return this.commaToken;
    }

    @Override
    @CheckForNull
    public PyExpressionTree exception() {
        return this.exception;
    }

    @Override
    @CheckForNull
    public PyExpressionTree exceptionInstance() {
        return this.exceptionInstance;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXCEPT_CLAUSE;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitExceptClause(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.body, this.exception, this.exceptionInstance);
    }
}

