/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import org.sonar.python.api.tree.PyExpressionListTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyExpressionListTreeImpl
extends PyTree
implements PyExpressionListTree {
    private final List<PyExpressionTree> expressions;

    public PyExpressionListTreeImpl(AstNode astNode, List<PyExpressionTree> expressions) {
        super(astNode);
        this.expressions = expressions;
    }

    public PyExpressionListTreeImpl(List<PyExpressionTree> expressions) {
        super(expressions.get(0).firstToken(), expressions.get(expressions.size() - 1).lastToken());
        this.expressions = expressions;
    }

    @Override
    public List<PyExpressionTree> expressions() {
        return this.expressions;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXPRESSION_LIST;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitExpressionList(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.expressions);
    }
}

