/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyForStatementTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyForStatementTreeImpl
extends PyTree
implements PyForStatementTree {
    private final Token forKeyword;
    private final List<PyExpressionTree> expressions;
    private final Token inKeyword;
    private final List<PyExpressionTree> testExpressions;
    private final Token colon;
    private final PyStatementListTree body;
    @Nullable
    private final Token elseKeyword;
    @Nullable
    private final Token elseColon;
    private final PyStatementListTree elseBody;
    private final Token asyncKeyword;
    private final boolean isAsync;

    public PyForStatementTreeImpl(AstNode astNode, Token forKeyword, List<PyExpressionTree> expressions, Token inKeyword, List<PyExpressionTree> testExpressions, Token colon, PyStatementListTree body, @Nullable Token elseKeyword, @Nullable Token elseColon, @Nullable PyStatementListTree elseBody, @Nullable Token asyncKeyword) {
        super(astNode);
        this.forKeyword = forKeyword;
        this.expressions = expressions;
        this.inKeyword = inKeyword;
        this.testExpressions = testExpressions;
        this.colon = colon;
        this.body = body;
        this.elseKeyword = elseKeyword;
        this.elseColon = elseColon;
        this.elseBody = elseBody;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitForStatement(this);
    }

    @Override
    public Token forKeyword() {
        return this.forKeyword;
    }

    @Override
    public List<PyExpressionTree> expressions() {
        return this.expressions;
    }

    @Override
    public Token inKeyword() {
        return this.inKeyword;
    }

    @Override
    public List<PyExpressionTree> testExpressions() {
        return this.testExpressions;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public PyStatementListTree body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @CheckForNull
    public Token elseColon() {
        return this.elseColon;
    }

    @Override
    @CheckForNull
    public PyStatementListTree elseBody() {
        return this.elseBody;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.expressions, this.testExpressions, Arrays.asList(this.body, this.elseBody)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

