/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.tree.PyAliasedNameTree;
import org.sonar.python.api.tree.PyDottedNameTree;
import org.sonar.python.api.tree.PyImportFromTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyImportFromTreeImpl
extends PyTree
implements PyImportFromTree {
    private final Token fromKeyword;
    private final List<Token> dottedPrefixForModule;
    private final PyDottedNameTree moduleName;
    private final Token importKeyword;
    private final List<PyAliasedNameTree> aliasedImportNames;
    private final boolean isWildcardImport;
    private final Token wildcard;

    public PyImportFromTreeImpl(AstNode astNode, Token fromKeyword, @Nullable List<Token> dottedPrefixForModule, @Nullable PyDottedNameTree moduleName, Token importKeyword, @Nullable List<PyAliasedNameTree> aliasedImportNames, boolean isWildcardImport) {
        super(astNode);
        this.fromKeyword = fromKeyword;
        this.dottedPrefixForModule = dottedPrefixForModule;
        this.moduleName = moduleName;
        this.importKeyword = importKeyword;
        this.aliasedImportNames = aliasedImportNames == null ? Collections.emptyList() : aliasedImportNames;
        this.isWildcardImport = isWildcardImport;
        this.wildcard = isWildcardImport ? astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL}).getToken() : null;
    }

    @Override
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    @CheckForNull
    public PyDottedNameTree module() {
        return this.moduleName;
    }

    @Override
    public Token importKeyword() {
        return this.importKeyword;
    }

    @Override
    @CheckForNull
    public List<Token> dottedPrefixForModule() {
        return this.dottedPrefixForModule;
    }

    @Override
    public List<PyAliasedNameTree> importedNames() {
        return this.aliasedImportNames;
    }

    @Override
    public boolean isWildcardImport() {
        return this.isWildcardImport;
    }

    @Override
    @CheckForNull
    public Token wildcard() {
        return this.wildcard;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IMPORT_FROM;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitImportFrom(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.aliasedImportNames, Collections.singletonList(this.moduleName)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

