/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyKeyValuePairTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyKeyValuePairTreeImpl
extends PyTree
implements PyKeyValuePairTree {
    private final Token starStarToken;
    private final PyExpressionTree expression;
    private final PyExpressionTree key;
    private final Token colon;
    private final PyExpressionTree value;

    public PyKeyValuePairTreeImpl(Token starStarToken, PyExpressionTree expression) {
        super(starStarToken, expression.lastToken());
        this.starStarToken = starStarToken;
        this.expression = expression;
        this.key = null;
        this.colon = null;
        this.value = null;
    }

    public PyKeyValuePairTreeImpl(PyExpressionTree key, Token colon, PyExpressionTree value) {
        super(key.firstToken(), value.lastToken());
        this.key = key;
        this.colon = colon;
        this.value = value;
        this.starStarToken = null;
        this.expression = null;
    }

    @Override
    @CheckForNull
    public PyExpressionTree key() {
        return this.key;
    }

    @Override
    @CheckForNull
    public Token colon() {
        return this.colon;
    }

    @Override
    @CheckForNull
    public PyExpressionTree value() {
        return this.value;
    }

    @Override
    @CheckForNull
    public Token starStarToken() {
        return this.starStarToken;
    }

    @Override
    @CheckForNull
    public PyExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitKeyValuePair(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.expression, this.key, this.value);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.KEY_VALUE_PAIR;
    }
}

