/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyLambdaExpressionTree;
import org.sonar.python.api.tree.PyParameterListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyLambdaExpressionTreeImpl
extends PyTree
implements PyLambdaExpressionTree {
    private final Token lambdaKeyword;
    private final Token colonToken;
    private final PyExpressionTree body;
    private final PyParameterListTree parameterList;

    public PyLambdaExpressionTreeImpl(AstNode astNode, Token lambdaKeyword, Token colonToken, PyExpressionTree body, @Nullable PyParameterListTree parameterList) {
        super(astNode);
        this.lambdaKeyword = lambdaKeyword;
        this.colonToken = colonToken;
        this.body = body;
        this.parameterList = parameterList;
    }

    @Override
    public Token lambdaKeyword() {
        return this.lambdaKeyword;
    }

    @Override
    public Token colonToken() {
        return this.colonToken;
    }

    @Override
    public PyExpressionTree expression() {
        return this.body;
    }

    @Override
    @CheckForNull
    public PyParameterListTree parameters() {
        return this.parameterList;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LAMBDA;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitLambda(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.parameterList, this.body);
    }
}

