/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.python.api.tree.PyAnyParameterTree;
import org.sonar.python.api.tree.PyParameterListTree;
import org.sonar.python.api.tree.PyParameterTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyParameterListTreeImpl
extends PyTree
implements PyParameterListTree {
    private final List<PyAnyParameterTree> parameters;

    public PyParameterListTreeImpl(AstNode node, List<PyAnyParameterTree> parameters) {
        super(node);
        this.parameters = parameters;
    }

    @Override
    public List<PyParameterTree> nonTuple() {
        return this.parameters.stream().filter(PyParameterTree.class::isInstance).map(PyParameterTree.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<PyAnyParameterTree> all() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitParameterList(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARAMETER_LIST;
    }
}

