/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyRaiseStatementTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyRaiseStatementTreeImpl
extends PyTree
implements PyRaiseStatementTree {
    private final Token raiseKeyword;
    private final List<PyExpressionTree> expressions;
    private final Token fromKeyword;
    private final PyExpressionTree fromExpression;

    public PyRaiseStatementTreeImpl(AstNode astNode, Token raiseKeyword, List<PyExpressionTree> expressions, @Nullable Token fromKeyword, @Nullable PyExpressionTree fromExpression) {
        super(astNode);
        this.raiseKeyword = raiseKeyword;
        this.expressions = expressions;
        this.fromKeyword = fromKeyword;
        this.fromExpression = fromExpression;
    }

    @Override
    public Token raiseKeyword() {
        return this.raiseKeyword;
    }

    @Override
    @CheckForNull
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    @CheckForNull
    public PyExpressionTree fromExpression() {
        return this.fromExpression;
    }

    @Override
    public List<PyExpressionTree> expressions() {
        return this.expressions;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RAISE_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitRaiseStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.expressions, Collections.singletonList(this.fromExpression)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

