/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PySliceItemTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PySliceItemTreeImpl
extends PyTree
implements PySliceItemTree {
    private final PyExpressionTree lowerBound;
    private final Token boundSeparator;
    private final PyExpressionTree upperBound;
    private final Token strideSeparator;
    private final PyExpressionTree stride;

    public PySliceItemTreeImpl(AstNode node, @Nullable PyExpressionTree lowerBound, Token boundSeparator, @Nullable PyExpressionTree upperBound, @Nullable Token strideSeparator, @Nullable PyExpressionTree stride) {
        super(node);
        this.lowerBound = lowerBound;
        this.boundSeparator = boundSeparator;
        this.upperBound = upperBound;
        this.strideSeparator = strideSeparator;
        this.stride = stride;
    }

    @Override
    @CheckForNull
    public PyExpressionTree lowerBound() {
        return this.lowerBound;
    }

    @Override
    public Token boundSeparator() {
        return this.boundSeparator;
    }

    @Override
    @CheckForNull
    public PyExpressionTree upperBound() {
        return this.upperBound;
    }

    @Override
    @CheckForNull
    public Token strideSeparator() {
        return this.strideSeparator;
    }

    @Override
    @CheckForNull
    public PyExpressionTree stride() {
        return this.stride;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitSliceItem(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.lowerBound, this.upperBound, this.stride);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SLICE_ITEM;
    }
}

