/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import org.sonar.python.api.tree.PyStringElementTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyStringElementImpl
extends PyTree
implements PyStringElementTree {
    private String value;

    PyStringElementImpl(AstNode node) {
        super(node);
        this.value = node.getTokenValue();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_ELEMENT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitStringElement(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.emptyList();
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String trimmedQuotesValue() {
        String trimmed = PyStringElementImpl.removePrefix(this.value);
        int startIndex = 1;
        if (PyStringElementImpl.isTripleQuote(trimmed)) {
            startIndex = 3;
        }
        return trimmed.substring(startIndex, trimmed.length() - startIndex);
    }

    @Override
    public String prefix() {
        return this.value.substring(0, this.value.length() - PyStringElementImpl.removePrefix(this.value).length());
    }

    private static boolean isTripleQuote(String trimmed) {
        if (trimmed.length() >= 6) {
            char startChar = trimmed.charAt(0);
            return startChar == trimmed.charAt(1) && startChar == trimmed.charAt(2);
        }
        return false;
    }

    private static String removePrefix(String value) {
        if (PyStringElementImpl.isCharQuote(value.charAt(0))) {
            return value;
        }
        return PyStringElementImpl.removePrefix(value.substring(1));
    }

    private static boolean isCharQuote(char character) {
        return character == '\'' || character == '\"';
    }
}

