/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.Tree;

public abstract class PyTree
implements Tree {
    private final AstNode node;
    private final Token firstToken;
    private final Token lastToken;
    private Tree parent = null;

    public PyTree(AstNode node) {
        this.node = node;
        this.firstToken = null;
        this.lastToken = null;
    }

    public PyTree(Token firstToken, Token lastToken) {
        this.node = null;
        this.firstToken = firstToken;
        this.lastToken = lastToken;
    }

    @Override
    public boolean is(Tree.Kind kind) {
        return kind == this.getKind();
    }

    @Override
    @CheckForNull
    public AstNode astNode() {
        return this.node;
    }

    @Override
    public Token firstToken() {
        return this.node == null ? this.firstToken : this.node.getToken();
    }

    @Override
    public Token lastToken() {
        return this.node == null ? this.lastToken : this.node.getLastToken();
    }

    @Override
    public Tree parent() {
        return this.parent;
    }

    protected void setParent(Tree parent) {
        this.parent = parent;
    }
}

