/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyTupleTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyTupleTreeImpl
extends PyTree
implements PyTupleTree {
    private final Token leftParenthesis;
    private final List<PyExpressionTree> elements;
    private final List<Token> commas;
    private final Token rightParenthesis;

    public PyTupleTreeImpl(AstNode node, @Nullable Token leftParenthesis, List<PyExpressionTree> elements, List<Token> commas, @Nullable Token rightParenthesis) {
        super(node);
        this.leftParenthesis = leftParenthesis;
        this.elements = elements;
        this.commas = commas;
        this.rightParenthesis = rightParenthesis;
    }

    @Override
    @CheckForNull
    public Token leftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    public List<PyExpressionTree> elements() {
        return this.elements;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    @CheckForNull
    public Token rightParenthesis() {
        return this.rightParenthesis;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitTuple(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TUPLE;
    }
}

