/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyUnaryExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyUnaryExpressionTreeImpl
extends PyTree
implements PyUnaryExpressionTree {
    private static final Map<String, Tree.Kind> KINDS_BY_OPERATOR = PyUnaryExpressionTreeImpl.kindsByOperator();
    private final Tree.Kind kind;
    private final Token operator;
    private final PyExpressionTree expression;

    private static Map<String, Tree.Kind> kindsByOperator() {
        HashMap<String, Tree.Kind> map = new HashMap<String, Tree.Kind>();
        map.put("+", Tree.Kind.UNARY_PLUS);
        map.put("-", Tree.Kind.UNARY_MINUS);
        map.put("~", Tree.Kind.BITWISE_COMPLEMENT);
        map.put("not", Tree.Kind.NOT);
        return map;
    }

    public PyUnaryExpressionTreeImpl(AstNode node, Token operator, PyExpressionTree expression) {
        super(node);
        this.kind = KINDS_BY_OPERATOR.get(operator.getValue());
        this.operator = operator;
        this.expression = expression;
    }

    @Override
    public Token operator() {
        return this.operator;
    }

    @Override
    public PyExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }
}

