/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyWhileStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyWhileStatementTreeImpl
extends PyTree
implements PyWhileStatementTree {
    private final Token whileKeyword;
    private final PyExpressionTree condition;
    private final Token colon;
    private final PyStatementListTree body;
    private final Token elseKeyword;
    private final Token elseColon;
    private final PyStatementListTree elseBody;

    public PyWhileStatementTreeImpl(AstNode astNode, Token whileKeyword, PyExpressionTree condition, Token colon, PyStatementListTree body, @Nullable Token elseKeyword, @Nullable Token elseColon, @Nullable PyStatementListTree elseBody) {
        super(astNode);
        this.whileKeyword = whileKeyword;
        this.condition = condition;
        this.colon = colon;
        this.body = body;
        this.elseKeyword = elseKeyword;
        this.elseColon = elseColon;
        this.elseBody = elseBody;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WHILE_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    @Override
    public Token whileKeyword() {
        return this.whileKeyword;
    }

    @Override
    public PyExpressionTree condition() {
        return this.condition;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public PyStatementListTree body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @CheckForNull
    public Token elseColon() {
        return this.elseColon;
    }

    @Override
    @CheckForNull
    public PyStatementListTree elseBody() {
        return this.elseBody;
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.condition, this.body, this.elseBody);
    }
}

