/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyWithItemTree;
import org.sonar.python.api.tree.PyWithStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyWithStatementTreeImpl
extends PyTree
implements PyWithStatementTree {
    private final List<PyWithItemTree> withItems;
    private final PyStatementListTree statements;
    private final Token asyncKeyword;
    private final boolean isAsync;
    private final Token colon;

    public PyWithStatementTreeImpl(AstNode node, List<PyWithItemTree> withItems, Token colon, PyStatementListTree statements, @Nullable Token asyncKeyword) {
        super(node);
        this.withItems = withItems;
        this.colon = colon;
        this.statements = statements;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public List<PyWithItemTree> withItems() {
        return this.withItems;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public PyStatementListTree statements() {
        return this.statements;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WITH_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitWithStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.withItems, Collections.singletonList(this.statements)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static class PyWithItemTreeImpl
    extends PyTree
    implements PyWithItemTree {
        private final PyExpressionTree test;
        private final Token as;
        private final PyExpressionTree expr;

        public PyWithItemTreeImpl(AstNode node, PyExpressionTree test, @Nullable Token as, @Nullable PyExpressionTree expr) {
            super(node);
            this.test = test;
            this.as = as;
            this.expr = expr;
        }

        @Override
        public PyExpressionTree test() {
            return this.test;
        }

        @Override
        @CheckForNull
        public Token as() {
            return this.as;
        }

        @Override
        @CheckForNull
        public PyExpressionTree expression() {
            return this.expr;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.WITH_ITEM;
        }

        @Override
        public void accept(PyTreeVisitor visitor) {
            visitor.visitWithItem(this);
        }

        @Override
        public List<Tree> children() {
            return Arrays.asList(this.test, this.expr);
        }
    }
}

