/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.api.tree.PyAliasedNameTree;
import org.sonar.python.api.tree.PyAnnotatedAssignmentTree;
import org.sonar.python.api.tree.PyAnyParameterTree;
import org.sonar.python.api.tree.PyArgListTree;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyAssertStatementTree;
import org.sonar.python.api.tree.PyAssignmentStatementTree;
import org.sonar.python.api.tree.PyBreakStatementTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyClassDefTree;
import org.sonar.python.api.tree.PyCompoundAssignmentStatementTree;
import org.sonar.python.api.tree.PyComprehensionClauseTree;
import org.sonar.python.api.tree.PyComprehensionForTree;
import org.sonar.python.api.tree.PyConditionalExpressionTree;
import org.sonar.python.api.tree.PyContinueStatementTree;
import org.sonar.python.api.tree.PyDecoratorTree;
import org.sonar.python.api.tree.PyDelStatementTree;
import org.sonar.python.api.tree.PyDottedNameTree;
import org.sonar.python.api.tree.PyElseStatementTree;
import org.sonar.python.api.tree.PyExceptClauseTree;
import org.sonar.python.api.tree.PyExecStatementTree;
import org.sonar.python.api.tree.PyExpressionListTree;
import org.sonar.python.api.tree.PyExpressionStatementTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyFileInputTree;
import org.sonar.python.api.tree.PyForStatementTree;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyGlobalStatementTree;
import org.sonar.python.api.tree.PyIfStatementTree;
import org.sonar.python.api.tree.PyImportFromTree;
import org.sonar.python.api.tree.PyImportNameTree;
import org.sonar.python.api.tree.PyImportStatementTree;
import org.sonar.python.api.tree.PyKeyValuePairTree;
import org.sonar.python.api.tree.PyLambdaExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyNonlocalStatementTree;
import org.sonar.python.api.tree.PyPassStatementTree;
import org.sonar.python.api.tree.PyPrintStatementTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.PyRaiseStatementTree;
import org.sonar.python.api.tree.PyReturnStatementTree;
import org.sonar.python.api.tree.PySliceItemTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyStatementTree;
import org.sonar.python.api.tree.PyStringElementTree;
import org.sonar.python.api.tree.PyTryStatementTree;
import org.sonar.python.api.tree.PyWithItemTree;
import org.sonar.python.api.tree.PyWithStatementTree;
import org.sonar.python.api.tree.PyYieldExpressionTree;
import org.sonar.python.api.tree.PyYieldStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyAliasedNameTreeImpl;
import org.sonar.python.tree.PyAnnotatedAssignmentTreeImpl;
import org.sonar.python.tree.PyArgListTreeImpl;
import org.sonar.python.tree.PyArgumentTreeImpl;
import org.sonar.python.tree.PyAssertStatementTreeImpl;
import org.sonar.python.tree.PyAssignmentStatementTreeImpl;
import org.sonar.python.tree.PyAwaitExpressionTreeImpl;
import org.sonar.python.tree.PyBinaryExpressionTreeImpl;
import org.sonar.python.tree.PyBreakStatementTreeImpl;
import org.sonar.python.tree.PyCallExpressionTreeImpl;
import org.sonar.python.tree.PyClassDefTreeImpl;
import org.sonar.python.tree.PyCompoundAssignmentStatementTreeImpl;
import org.sonar.python.tree.PyComprehensionExpressionTreeImpl;
import org.sonar.python.tree.PyComprehensionForTreeImpl;
import org.sonar.python.tree.PyComprehensionIfTreeImpl;
import org.sonar.python.tree.PyConditionalExpressionTreeImpl;
import org.sonar.python.tree.PyContinueStatementTreeImpl;
import org.sonar.python.tree.PyDecoratorTreeImpl;
import org.sonar.python.tree.PyDelStatementTreeImpl;
import org.sonar.python.tree.PyDictCompExpressionTreeImpl;
import org.sonar.python.tree.PyDictionaryLiteralTreeImpl;
import org.sonar.python.tree.PyDottedNameTreeImpl;
import org.sonar.python.tree.PyEllipsisExpressionTreeImpl;
import org.sonar.python.tree.PyElseStatementTreeImpl;
import org.sonar.python.tree.PyExceptClauseTreeImpl;
import org.sonar.python.tree.PyExecStatementTreeImpl;
import org.sonar.python.tree.PyExpressionListTreeImpl;
import org.sonar.python.tree.PyExpressionStatementTreeImpl;
import org.sonar.python.tree.PyFileInputTreeImpl;
import org.sonar.python.tree.PyFinallyClauseTreeImpl;
import org.sonar.python.tree.PyForStatementTreeImpl;
import org.sonar.python.tree.PyFunctionDefTreeImpl;
import org.sonar.python.tree.PyGlobalStatementTreeImpl;
import org.sonar.python.tree.PyIfStatementTreeImpl;
import org.sonar.python.tree.PyImportFromTreeImpl;
import org.sonar.python.tree.PyImportNameTreeImpl;
import org.sonar.python.tree.PyInExpressionTreeImpl;
import org.sonar.python.tree.PyIsExpressionTreeImpl;
import org.sonar.python.tree.PyKeyValuePairTreeImpl;
import org.sonar.python.tree.PyLambdaExpressionTreeImpl;
import org.sonar.python.tree.PyListLiteralTreeImpl;
import org.sonar.python.tree.PyNameTreeImpl;
import org.sonar.python.tree.PyNoneExpressionTreeImpl;
import org.sonar.python.tree.PyNonlocalStatementTreeImpl;
import org.sonar.python.tree.PyNumericLiteralTreeImpl;
import org.sonar.python.tree.PyParameterListTreeImpl;
import org.sonar.python.tree.PyParameterTreeImpl;
import org.sonar.python.tree.PyParenthesizedExpressionTreeImpl;
import org.sonar.python.tree.PyPassStatementTreeImpl;
import org.sonar.python.tree.PyPrintStatementTreeImpl;
import org.sonar.python.tree.PyQualifiedExpressionTreeImpl;
import org.sonar.python.tree.PyRaiseStatementTreeImpl;
import org.sonar.python.tree.PyReprExpressionTreeImpl;
import org.sonar.python.tree.PyReturnStatementTreeImpl;
import org.sonar.python.tree.PySetLiteralTreeImpl;
import org.sonar.python.tree.PySliceExpressionTreeImpl;
import org.sonar.python.tree.PySliceItemTreeImpl;
import org.sonar.python.tree.PySliceListTreeImpl;
import org.sonar.python.tree.PyStarredExpressionTreeImpl;
import org.sonar.python.tree.PyStatementListTreeImpl;
import org.sonar.python.tree.PyStringElementImpl;
import org.sonar.python.tree.PyStringLiteralTreeImpl;
import org.sonar.python.tree.PySubscriptionExpressionTreeImpl;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.PyTryStatementTreeImpl;
import org.sonar.python.tree.PyTupleParameterTreeImpl;
import org.sonar.python.tree.PyTupleTreeImpl;
import org.sonar.python.tree.PyTypeAnnotationTreeImpl;
import org.sonar.python.tree.PyUnaryExpressionTreeImpl;
import org.sonar.python.tree.PyWhileStatementTreeImpl;
import org.sonar.python.tree.PyWithStatementTreeImpl;
import org.sonar.python.tree.PyYieldExpressionTreeImpl;
import org.sonar.python.tree.PyYieldStatementTreeImpl;

public class PythonTreeMaker {
    public PyFileInputTree fileInput(AstNode astNode) {
        List<PyStatementTree> statements = PythonTreeMaker.getStatements(astNode).stream().map(this::statement).collect(Collectors.toList());
        PyStatementListTreeImpl statementList = statements.isEmpty() ? null : new PyStatementListTreeImpl(astNode, statements, astNode.getTokens());
        PyFileInputTreeImpl pyFileInputTree = new PyFileInputTreeImpl(astNode, statementList, DocstringExtractor.extractDocstring(astNode));
        this.setParents(pyFileInputTree);
        return pyFileInputTree;
    }

    public void setParents(Tree root) {
        for (Tree child : root.children()) {
            if (child == null) continue;
            ((PyTree)child).setParent(root);
            this.setParents(child);
        }
    }

    PyStatementTree statement(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.IF_STMT})) {
            return this.ifStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.PASS_STMT})) {
            return this.passStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.PRINT_STMT})) {
            return this.printStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXEC_STMT})) {
            return this.execStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASSERT_STMT})) {
            return this.assertStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.DEL_STMT})) {
            return this.delStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.RETURN_STMT})) {
            return this.returnStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.YIELD_STMT})) {
            return this.yieldStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.RAISE_STMT})) {
            return this.raiseStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.BREAK_STMT})) {
            return this.breakStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CONTINUE_STMT})) {
            return this.continueStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
            return this.funcDefStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) {
            return this.classDefStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.IMPORT_STMT})) {
            return this.importStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            return this.forStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.WHILE_STMT})) {
            return this.whileStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.GLOBAL_STMT})) {
            return this.globalStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NONLOCAL_STMT})) {
            return this.nonlocalStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.ANNASSIGN})) {
            return this.annotatedAssignment(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
            return this.assignment(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.AUGASSIGN})) {
            return this.compoundAssignment(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT})) {
            return this.expressionStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TRY_STMT})) {
            return this.tryStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            return this.forStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT}) && astNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.WITH_STMT})) {
            return this.withStatement(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.WITH_STMT})) {
            return this.withStatement(astNode);
        }
        throw new IllegalStateException("Statement " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    public PyAnnotatedAssignmentTree annotatedAssignment(AstNode astNode) {
        AstNode annAssign = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ANNASSIGN});
        AstNode colonTokenNode = annAssign.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
        PyExpressionTree variable = this.exprListOrTestList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}));
        PyExpressionTree annotation = this.expression(annAssign.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
        AstNode equalTokenNode = annAssign.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        Token equalToken = null;
        PyExpressionTree assignedValue = null;
        if (equalTokenNode != null) {
            equalToken = equalTokenNode.getToken();
            assignedValue = this.expression(equalTokenNode.getNextSibling());
        }
        return new PyAnnotatedAssignmentTreeImpl(variable, colonTokenNode.getToken(), annotation, equalToken, assignedValue);
    }

    private PyStatementListTree getStatementListFromSuite(AstNode suite) {
        return new PyStatementListTreeImpl(suite, this.getStatementsFromSuite(suite), suite.getTokens());
    }

    private List<PyStatementTree> getStatementsFromSuite(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUITE})) {
            List<AstNode> statements = PythonTreeMaker.getStatements(astNode);
            if (statements.isEmpty()) {
                AstNode stmtListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
                return stmtListNode.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).stream().map(AstNode::getFirstChild).map(this::statement).collect(Collectors.toList());
            }
            return statements.stream().map(this::statement).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<AstNode> getStatements(AstNode astNode) {
        List statements = astNode.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        return statements.stream().flatMap(stmt -> {
            if (stmt.hasDirectChildren(new AstNodeType[]{PythonGrammar.STMT_LIST})) {
                AstNode stmtListNode = stmt.getFirstChild(new AstNodeType[]{PythonGrammar.STMT_LIST});
                return stmtListNode.getChildren(new AstNodeType[]{PythonGrammar.SIMPLE_STMT}).stream().map(AstNode::getFirstChild);
            }
            return stmt.getChildren(new AstNodeType[]{PythonGrammar.COMPOUND_STMT}).stream().map(AstNode::getFirstChild);
        }).collect(Collectors.toList());
    }

    public PyPrintStatementTree printStatement(AstNode astNode) {
        List<PyExpressionTree> expressions = this.expressionsFromTest(astNode);
        return new PyPrintStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0), expressions);
    }

    public PyExecStatementTree execStatement(AstNode astNode) {
        PyExpressionTree expression = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        List<PyExpressionTree> expressions = this.expressionsFromTest(astNode);
        if (expressions.isEmpty()) {
            return new PyExecStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0), expression);
        }
        return new PyExecStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0), expression, expressions.get(0), expressions.size() == 2 ? expressions.get(1) : null);
    }

    public PyAssertStatementTree assertStatement(AstNode astNode) {
        List<PyExpressionTree> expressions = this.expressionsFromTest(astNode);
        return new PyAssertStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0), expressions);
    }

    public PyPassStatementTree passStatement(AstNode astNode) {
        return new PyPassStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0));
    }

    public PyDelStatementTree delStatement(AstNode astNode) {
        List<PyExpressionTree> expressionTrees = this.expressionsFromExprList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        return new PyDelStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0), expressionTrees);
    }

    public PyReturnStatementTree returnStatement(AstNode astNode) {
        AstNode testListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST});
        List<PyExpressionTree> expressionTrees = Collections.emptyList();
        if (testListNode != null) {
            expressionTrees = this.expressionsFromTest(testListNode);
        }
        return new PyReturnStatementTreeImpl(astNode, (Token)astNode.getTokens().get(0), expressionTrees);
    }

    public PyYieldStatementTree yieldStatement(AstNode astNode) {
        return new PyYieldStatementTreeImpl(astNode, this.yieldExpression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.YIELD_EXPR})));
    }

    public PyYieldExpressionTree yieldExpression(AstNode astNode) {
        Token yieldKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.YIELD}).getToken();
        AstNode nodeContainingExpression = astNode;
        AstNode fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM});
        if (fromKeyword == null) {
            nodeContainingExpression = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST});
        }
        List<PyExpressionTree> expressionTrees = Collections.emptyList();
        if (nodeContainingExpression != null) {
            expressionTrees = this.expressionsFromTest(nodeContainingExpression);
        }
        return new PyYieldExpressionTreeImpl(astNode, yieldKeyword, fromKeyword == null ? null : fromKeyword.getToken(), expressionTrees);
    }

    public PyRaiseStatementTree raiseStatement(AstNode astNode) {
        AstNode fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM});
        List expressions = new ArrayList<AstNode>();
        AstNode fromExpression = null;
        if (fromKeyword != null) {
            expressions.add(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
            fromExpression = astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST});
        } else {
            expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST});
        }
        List<PyExpressionTree> expressionTrees = expressions.stream().map(this::expression).collect(Collectors.toList());
        return new PyRaiseStatementTreeImpl(astNode, astNode.getFirstChild(new AstNodeType[]{PythonKeyword.RAISE}).getToken(), expressionTrees, fromKeyword == null ? null : fromKeyword.getToken(), fromExpression == null ? null : this.expression(fromExpression));
    }

    public PyBreakStatementTree breakStatement(AstNode astNode) {
        return new PyBreakStatementTreeImpl(astNode, astNode.getToken());
    }

    public PyContinueStatementTree continueStatement(AstNode astNode) {
        return new PyContinueStatementTreeImpl(astNode, astNode.getToken());
    }

    public PyImportStatementTree importStatement(AstNode astNode) {
        AstNode importStmt = astNode.getFirstChild();
        if (importStmt.is(new AstNodeType[]{PythonGrammar.IMPORT_NAME})) {
            return this.importName(importStmt);
        }
        return this.importFromStatement(importStmt);
    }

    private PyImportNameTree importName(AstNode astNode) {
        Token importKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IMPORT}).getToken();
        List<PyAliasedNameTree> aliasedNames = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAMES}).getChildren(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAME}).stream().map(this::aliasedName).collect(Collectors.toList());
        return new PyImportNameTreeImpl(astNode, importKeyword, aliasedNames);
    }

    public PyImportFromTree importFromStatement(AstNode astNode) {
        Token importKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IMPORT}).getToken();
        Token fromKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FROM}).getToken();
        List<Token> dottedPrefixForModule = astNode.getChildren(new AstNodeType[]{PythonPunctuator.DOT}).stream().map(AstNode::getToken).collect(Collectors.toList());
        AstNode moduleNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME});
        PyDottedNameTree moduleName = null;
        if (moduleNode != null) {
            moduleName = this.dottedName(moduleNode);
        }
        AstNode importAsnames = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAMES});
        List aliasedImportNames = null;
        boolean isWildcardImport = true;
        if (importAsnames != null) {
            aliasedImportNames = importAsnames.getChildren(new AstNodeType[]{PythonGrammar.IMPORT_AS_NAME}).stream().map(this::aliasedName).collect(Collectors.toList());
            isWildcardImport = false;
        }
        return new PyImportFromTreeImpl(astNode, fromKeyword, dottedPrefixForModule, moduleName, importKeyword, aliasedImportNames, isWildcardImport);
    }

    private PyAliasedNameTree aliasedName(AstNode astNode) {
        PyDottedNameTree dottedName;
        AstNode asKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        if (astNode.is(new AstNodeType[]{PythonGrammar.DOTTED_AS_NAME})) {
            dottedName = this.dottedName(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME}));
        } else {
            AstNode importedName = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            dottedName = new PyDottedNameTreeImpl(astNode, Collections.singletonList(PythonTreeMaker.name(importedName)));
        }
        if (asKeyword == null) {
            return new PyAliasedNameTreeImpl(astNode, null, dottedName, null);
        }
        return new PyAliasedNameTreeImpl(astNode, asKeyword.getToken(), dottedName, PythonTreeMaker.name(astNode.getLastChild(new AstNodeType[]{PythonGrammar.NAME})));
    }

    private PyDottedNameTree dottedName(AstNode astNode) {
        List<PyNameTree> names = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new PyDottedNameTreeImpl(astNode, names);
    }

    public PyGlobalStatementTree globalStatement(AstNode astNode) {
        Token globalKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.GLOBAL}).getToken();
        List<PyNameTree> variables = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new PyGlobalStatementTreeImpl(astNode, globalKeyword, variables);
    }

    public PyNonlocalStatementTree nonlocalStatement(AstNode astNode) {
        Token nonlocalKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.NONLOCAL}).getToken();
        List<PyNameTree> variables = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME}).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new PyNonlocalStatementTreeImpl(astNode, nonlocalKeyword, variables);
    }

    public PyIfStatementTree ifStatement(AstNode astNode) {
        Token ifToken = (Token)astNode.getTokens().get(0);
        AstNode condition = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        AstNode suite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        PyStatementListTree statements = this.getStatementListFromSuite(suite);
        AstNode elseSuite = astNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        PyElseStatementTree elseStatement = null;
        if (elseSuite.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonKeyword.ELSE})) {
            elseStatement = this.elseStatement(elseSuite);
        }
        List<PyIfStatementTree> elifBranches = astNode.getChildren(new AstNodeType[]{PythonKeyword.ELIF}).stream().map(this::elifStatement).collect(Collectors.toList());
        return new PyIfStatementTreeImpl(ifToken, this.expression(condition), statements, elifBranches, elseStatement);
    }

    private PyIfStatementTree elifStatement(AstNode astNode) {
        Token elifToken = astNode.getToken();
        AstNode suite = astNode.getNextSibling().getNextSibling().getNextSibling();
        AstNode condition = astNode.getNextSibling();
        PyStatementListTree statements = this.getStatementListFromSuite(suite);
        return new PyIfStatementTreeImpl(elifToken, this.expression(condition), statements);
    }

    private PyElseStatementTree elseStatement(AstNode astNode) {
        Token elseToken = astNode.getPreviousSibling().getPreviousSibling().getToken();
        PyStatementListTree statements = this.getStatementListFromSuite(astNode);
        return new PyElseStatementTreeImpl(elseToken, statements);
    }

    public PyFunctionDefTree funcDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        List<PyDecoratorTree> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR}).stream().map(this::decorator).collect(Collectors.toList());
        }
        PyNameTree name = PythonTreeMaker.name(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        PyParameterListTreeImpl parameterList = null;
        AstNode typedArgListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (typedArgListNode != null) {
            List<PyAnyParameterTree> arguments = typedArgListNode.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF}).stream().map(this::parameter).collect(Collectors.toList());
            parameterList = new PyParameterListTreeImpl(typedArgListNode, arguments);
        }
        PyStatementListTree body = this.getStatementListFromSuite(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}));
        AstNode defNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.DEF});
        Token asyncToken = null;
        AstNode defPreviousSibling = defNode.getPreviousSibling();
        if (defPreviousSibling != null && defPreviousSibling.getToken().getValue().equals("async")) {
            asyncToken = defPreviousSibling.getToken();
        }
        Token lPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}).getToken();
        Token rPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}).getToken();
        PyTypeAnnotationTreeImpl returnType = null;
        AstNode returnTypeNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUN_RETURN_ANNOTATION});
        if (returnTypeNode != null) {
            List children = returnTypeNode.getChildren();
            returnType = new PyTypeAnnotationTreeImpl(((AstNode)children.get(0)).getToken(), ((AstNode)children.get(1)).getToken(), this.expression((AstNode)children.get(2)));
        }
        Token colon = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken();
        return new PyFunctionDefTreeImpl(astNode, decorators, asyncToken, defNode.getToken(), name, lPar, parameterList, rPar, returnType, colon, body, PythonTreeMaker.isMethodDefinition(astNode), DocstringExtractor.extractDocstring(astNode));
    }

    private PyDecoratorTree decorator(AstNode astNode) {
        Token atToken = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.AT}).getToken();
        PyDottedNameTree dottedName = this.dottedName(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DOTTED_NAME}));
        AstNode lPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS});
        AstNode rPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS});
        PyArgListTree argListTree = this.argList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST}));
        return new PyDecoratorTreeImpl(astNode, atToken, dottedName, lPar, argListTree, rPar);
    }

    private static boolean isMethodDefinition(AstNode node) {
        AstNode parent = node.getParent();
        for (int i = 0; i < 3; ++i) {
            if (parent == null) continue;
            parent = parent.getParent();
        }
        return parent != null && parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public PyClassDefTree classDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DECORATORS});
        List<PyDecoratorTree> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(new AstNodeType[]{PythonGrammar.DECORATOR}).stream().map(this::decorator).collect(Collectors.toList());
        }
        PyNameTree name = PythonTreeMaker.name(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        PyArgListTree args = null;
        AstNode leftPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS});
        if (leftPar != null) {
            args = this.argList(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST}));
        }
        PyStatementListTree body = this.getStatementListFromSuite(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}));
        Token classToken = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.CLASS}).getToken();
        AstNode rightPar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS});
        Token colon = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken();
        return new PyClassDefTreeImpl(astNode, decorators, classToken, name, leftPar != null ? leftPar.getToken() : null, args, rightPar != null ? rightPar.getToken() : null, colon, body, DocstringExtractor.extractDocstring(astNode));
    }

    private static PyNameTree name(AstNode astNode) {
        return new PyNameTreeImpl(astNode, astNode.getFirstChild(new AstNodeType[]{GenericTokenType.IDENTIFIER}).getTokenOriginalValue());
    }

    public PyForStatementTree forStatement(AstNode astNode) {
        AstNode forStatementNode = astNode;
        Token asyncToken = null;
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT})) {
            asyncToken = astNode.getFirstChild().getToken();
            forStatementNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FOR_STMT});
        }
        Token forKeyword = forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.FOR}).getToken();
        Token inKeyword = forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken();
        Token colon = forStatementNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken();
        List<PyExpressionTree> expressions = this.expressionsFromExprList(forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        List<PyExpressionTree> testExpressions = this.expressionsFromTest(forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}));
        AstNode firstSuite = forStatementNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        PyStatementListTree body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = forStatementNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode elseKeywordNode = forStatementNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        Token elseKeyword = null;
        Token elseColonKeyword = null;
        if (elseKeywordNode != null) {
            elseKeyword = elseKeywordNode.getToken();
            elseColonKeyword = elseKeywordNode.getNextSibling().getToken();
        }
        PyStatementListTree elseBody = lastSuite == firstSuite ? null : this.getStatementListFromSuite(lastSuite);
        return new PyForStatementTreeImpl(forStatementNode, forKeyword, expressions, inKeyword, testExpressions, colon, body, elseKeyword, elseColonKeyword, elseBody, asyncToken);
    }

    public PyWhileStatementTreeImpl whileStatement(AstNode astNode) {
        Token whileKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.WHILE}).getToken();
        Token colon = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken();
        PyExpressionTree condition = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
        AstNode firstSuite = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        PyStatementListTree body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = astNode.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode elseKeywordNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        Token elseKeyword = null;
        Token elseColonKeyword = null;
        if (elseKeywordNode != null) {
            elseKeyword = elseKeywordNode.getToken();
            elseColonKeyword = elseKeywordNode.getNextSibling().getToken();
        }
        PyStatementListTree elseBody = lastSuite == firstSuite ? null : this.getStatementListFromSuite(lastSuite);
        return new PyWhileStatementTreeImpl(astNode, whileKeyword, condition, colon, body, elseKeyword, elseColonKeyword, elseBody);
    }

    public PyExpressionStatementTree expressionStatement(AstNode astNode) {
        List<PyExpressionTree> expressions = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}).getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
        return new PyExpressionStatementTreeImpl(astNode, expressions);
    }

    public PyAssignmentStatementTree assignment(AstNode astNode) {
        ArrayList<Token> assignTokens = new ArrayList<Token>();
        ArrayList<PyExpressionListTree> lhsExpressions = new ArrayList<PyExpressionListTree>();
        List assignNodes = astNode.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN});
        for (AstNode assignNode : assignNodes) {
            assignTokens.add(assignNode.getToken());
            lhsExpressions.add(this.expressionList(assignNode.getPreviousSibling()));
        }
        AstNode assignedValueNode = ((AstNode)assignNodes.get(assignNodes.size() - 1)).getNextSibling();
        PyExpressionTree assignedValue = assignedValueNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR}) ? this.yieldExpression(assignedValueNode) : this.exprListOrTestList(assignedValueNode);
        return new PyAssignmentStatementTreeImpl(astNode, assignTokens, lhsExpressions, assignedValue);
    }

    public PyCompoundAssignmentStatementTree compoundAssignment(AstNode astNode) {
        AstNode augAssignNodes = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.AUGASSIGN});
        PyExpressionTree lhsExpression = this.exprListOrTestList(augAssignNodes.getPreviousSibling());
        AstNode rhsAstNode = augAssignNodes.getNextSibling();
        PyExpressionTree rhsExpression = rhsAstNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR}) ? this.yieldExpression(rhsAstNode) : this.exprListOrTestList(rhsAstNode);
        return new PyCompoundAssignmentStatementTreeImpl(astNode, lhsExpression, augAssignNodes.getToken(), rhsExpression);
    }

    private PyExpressionListTree expressionList(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR, PythonGrammar.TESTLIST_COMP})) {
            List<PyExpressionTree> expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
            return new PyExpressionListTreeImpl(astNode, expressions);
        }
        return new PyExpressionListTreeImpl(astNode, Collections.singletonList(this.expression(astNode)));
    }

    public PyTryStatementTree tryStatement(AstNode astNode) {
        Token tryKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.TRY}).getToken();
        PyStatementListTree tryBody = this.getStatementListFromSuite(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE}));
        List<PyExceptClauseTree> exceptClauseTrees = astNode.getChildren(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE}).stream().map(except -> {
            AstNode suite = except.getNextSibling().getNextSibling();
            return this.exceptClause((AstNode)except, this.getStatementListFromSuite(suite));
        }).collect(Collectors.toList());
        PyFinallyClauseTreeImpl finallyClause = null;
        AstNode finallyNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.FINALLY});
        if (finallyNode != null) {
            AstNode finallySuite = finallyNode.getNextSibling().getNextSibling();
            PyStatementListTree body = this.getStatementListFromSuite(finallySuite);
            finallyClause = new PyFinallyClauseTreeImpl(finallyNode.getToken(), body);
        }
        PyElseStatementTree elseStatementTree = null;
        AstNode elseNode = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (elseNode != null) {
            elseStatementTree = this.elseStatement(elseNode.getNextSibling().getNextSibling());
        }
        return new PyTryStatementTreeImpl(astNode, tryKeyword, tryBody, exceptClauseTrees, finallyClause, elseStatementTree);
    }

    public PyWithStatementTree withStatement(AstNode astNode) {
        AstNode withStmtNode = astNode;
        Token asyncKeyword = null;
        if (astNode.is(new AstNodeType[]{PythonGrammar.ASYNC_STMT})) {
            withStmtNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.WITH_STMT});
            asyncKeyword = astNode.getFirstChild().getToken();
        }
        List<PyWithItemTree> withItems = this.withItems(withStmtNode.getChildren(new AstNodeType[]{PythonGrammar.WITH_ITEM}));
        AstNode suite = withStmtNode.getFirstChild(new AstNodeType[]{PythonGrammar.SUITE});
        Token colon = suite.getPreviousSibling().getToken();
        PyStatementListTree statements = this.getStatementListFromSuite(suite);
        return new PyWithStatementTreeImpl(withStmtNode, withItems, colon, statements, asyncKeyword);
    }

    private List<PyWithItemTree> withItems(List<AstNode> withItems) {
        return withItems.stream().map(this::withItem).collect(Collectors.toList());
    }

    private PyWithItemTree withItem(AstNode withItem) {
        AstNode testNode = withItem.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        PyExpressionTree test = this.expression(testNode);
        AstNode asNode = testNode.getNextSibling();
        PyExpressionTree expr = null;
        Token as = null;
        if (asNode != null) {
            as = asNode.getToken();
            expr = this.expression(withItem.getFirstChild(new AstNodeType[]{PythonGrammar.EXPR}));
        }
        return new PyWithStatementTreeImpl.PyWithItemTreeImpl(withItem, test, as, expr);
    }

    private PyExceptClauseTree exceptClause(AstNode except, PyStatementListTree body) {
        Token exceptKeyword = except.getFirstChild(new AstNodeType[]{PythonKeyword.EXCEPT}).getToken();
        AstNode exceptionNode = except.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        if (exceptionNode == null) {
            return new PyExceptClauseTreeImpl(exceptKeyword, body);
        }
        AstNode asNode = except.getFirstChild(new AstNodeType[]{PythonKeyword.AS});
        AstNode commaNode = except.getFirstChild(new AstNodeType[]{PythonPunctuator.COMMA});
        if (asNode != null || commaNode != null) {
            PyExpressionTree exceptionInstance = this.expression(except.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
            return new PyExceptClauseTreeImpl(exceptKeyword, body, this.expression(exceptionNode), asNode, commaNode, exceptionInstance);
        }
        return new PyExceptClauseTreeImpl(exceptKeyword, body, this.expression(exceptionNode));
    }

    private List<PyExpressionTree> expressionsFromTest(AstNode astNode) {
        return astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
    }

    private List<PyExpressionTree> expressionsFromExprList(AstNode firstChild) {
        return firstChild.getChildren(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
    }

    private PyExpressionTree exprListOrTestList(AstNode exprListOrTestList) {
        List<PyExpressionTree> expressions = exprListOrTestList.getChildren(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.STAR_EXPR, PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
        List commas = exprListOrTestList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA});
        if (commas.isEmpty()) {
            return (PyExpressionTree)expressions.get(0);
        }
        List<Token> commaTokens = commas.stream().map(AstNode::getToken).collect(Collectors.toList());
        return new PyTupleTreeImpl(exprListOrTestList, null, expressions, commaTokens, null);
    }

    PyExpressionTree expression(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LBRACKET})) {
            return this.listLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            return this.parenthesized(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LCURLYBRACE})) {
            return this.dictOrSetLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.BACKTICK})) {
            return this.repr(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getFirstChild().is(new AstNodeType[]{PythonTokenType.STRING})) {
            return PythonTreeMaker.stringLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATOM}) && astNode.getChildren().size() == 1) {
            return this.expression(astNode.getFirstChild());
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.TEST}) && astNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.IF})) {
            return this.conditionalExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonTokenType.NUMBER})) {
            return PythonTreeMaker.numericLiteral(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR})) {
            return this.yieldExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.NAME})) {
            return PythonTreeMaker.name(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF})) {
            return this.qualifiedExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.CALL_EXPR})) {
            return this.callExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.EXPR, PythonGrammar.TEST, PythonGrammar.TEST_NOCOND})) {
            if (astNode.getChildren().size() == 1) {
                return this.expression(astNode.getFirstChild());
            }
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.A_EXPR, PythonGrammar.M_EXPR, PythonGrammar.SHIFT_EXPR, PythonGrammar.AND_EXPR, PythonGrammar.OR_EXPR, PythonGrammar.XOR_EXPR, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.COMPARISON})) {
            return this.binaryExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.POWER})) {
            return this.powerExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND})) {
            return this.lambdaExpression(astNode);
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.FACTOR, PythonGrammar.NOT_TEST})) {
            return new PyUnaryExpressionTreeImpl(astNode, astNode.getFirstChild().getToken(), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.STAR_EXPR})) {
            return new PyStarredExpressionTreeImpl(astNode, astNode.getToken(), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.SUBSCRIPTION_OR_SLICING})) {
            PyExpressionTree baseExpr = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}));
            Token leftBracket = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken();
            Token rightBracket = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken();
            return this.subscriptionOrSlicing(baseExpr, leftBracket, astNode, rightBracket);
        }
        if (astNode.is(new AstNodeType[]{PythonKeyword.NONE})) {
            return new PyNoneExpressionTreeImpl(astNode, astNode.getToken());
        }
        if (astNode.is(new AstNodeType[]{PythonGrammar.ELLIPSIS})) {
            return new PyEllipsisExpressionTreeImpl(astNode);
        }
        throw new IllegalStateException("Expression " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    private PyExpressionTree repr(AstNode astNode) {
        Token openingBacktick = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.BACKTICK}).getToken();
        Token closingBacktick = astNode.getLastChild(new AstNodeType[]{PythonPunctuator.BACKTICK}).getToken();
        List<PyExpressionTree> expressions = astNode.getChildren(new AstNodeType[]{PythonGrammar.TEST}).stream().map(this::expression).collect(Collectors.toList());
        PyExpressionListTreeImpl expressionListTree = new PyExpressionListTreeImpl(expressions);
        return new PyReprExpressionTreeImpl(astNode, openingBacktick, expressionListTree, closingBacktick);
    }

    private PyExpressionTree dictOrSetLiteral(AstNode astNode) {
        Token lCurlyBrace = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LCURLYBRACE}).getToken();
        Token rCurlyBrace = astNode.getLastChild(new AstNodeType[]{PythonPunctuator.RCURLYBRACE}).getToken();
        AstNode dictOrSetMaker = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.DICTORSETMAKER});
        if (dictOrSetMaker == null) {
            return new PyDictionaryLiteralTreeImpl(astNode, lCurlyBrace, Collections.emptyList(), Collections.emptyList(), rCurlyBrace);
        }
        AstNode compForNode = dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compForNode != null) {
            PyComprehensionForTree compFor = this.compFor(compForNode);
            AstNode colon = dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
            if (colon != null) {
                PyExpressionTree keyExpression = this.expression(dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}));
                PyExpressionTree valueExpression = this.expression(dictOrSetMaker.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
                return new PyDictCompExpressionTreeImpl(lCurlyBrace, keyExpression, colon.getToken(), valueExpression, compFor, rCurlyBrace);
            }
            PyExpressionTree resultExpression = this.expression(dictOrSetMaker.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}));
            return new PyComprehensionExpressionTreeImpl(Tree.Kind.SET_COMPREHENSION, lCurlyBrace, resultExpression, compFor, rCurlyBrace);
        }
        List<Token> commas = dictOrSetMaker.getChildren(new AstNodeType[]{PythonPunctuator.COMMA}).stream().map(AstNode::getToken).collect(Collectors.toList());
        if (dictOrSetMaker.hasDirectChildren(new AstNodeType[]{PythonPunctuator.COLON}) || dictOrSetMaker.hasDirectChildren(new AstNodeType[]{PythonPunctuator.MUL_MUL})) {
            ArrayList<PyKeyValuePairTree> keyValuePairTrees = new ArrayList<PyKeyValuePairTree>();
            List children = dictOrSetMaker.getChildren();
            int index = 0;
            while (index < children.size()) {
                AstNode currentChild = (AstNode)children.get(index);
                if (currentChild.is(new AstNodeType[]{PythonPunctuator.MUL_MUL})) {
                    keyValuePairTrees.add(new PyKeyValuePairTreeImpl(currentChild.getToken(), this.expression((AstNode)children.get(index + 1))));
                    index += 3;
                    continue;
                }
                keyValuePairTrees.add(new PyKeyValuePairTreeImpl(this.expression(currentChild), ((AstNode)children.get(index + 1)).getToken(), this.expression((AstNode)children.get(index + 2))));
                index += 4;
            }
            return new PyDictionaryLiteralTreeImpl(astNode, lCurlyBrace, commas, keyValuePairTrees, rCurlyBrace);
        }
        List<PyExpressionTree> expressions = dictOrSetMaker.getChildren(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}).stream().map(this::expression).collect(Collectors.toList());
        return new PySetLiteralTreeImpl(astNode, lCurlyBrace, expressions, commas, rCurlyBrace);
    }

    private PyExpressionTree parenthesized(AstNode atom) {
        Token lPar = atom.getFirstChild().getToken();
        Token rPar = atom.getLastChild().getToken();
        AstNode yieldNode = atom.getFirstChild(new AstNodeType[]{PythonGrammar.YIELD_EXPR});
        if (yieldNode != null) {
            return new PyParenthesizedExpressionTreeImpl(lPar, this.expression(yieldNode), rPar);
        }
        AstNode testListComp = atom.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_COMP});
        if (testListComp == null) {
            return new PyTupleTreeImpl(atom, lPar, Collections.emptyList(), Collections.emptyList(), rPar);
        }
        AstNode compFor = testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compFor != null) {
            return new PyComprehensionExpressionTreeImpl(Tree.Kind.GENERATOR_EXPR, lPar, this.expression(testListComp.getFirstChild()), this.compFor(compFor), rPar);
        }
        PyExpressionListTree expressionList = this.expressionList(testListComp);
        List commas = testListComp.getChildren(new AstNodeType[]{PythonPunctuator.COMMA});
        if (commas.isEmpty()) {
            PyExpressionTree expression = expressionList.expressions().get(0);
            return new PyParenthesizedExpressionTreeImpl(lPar, expression, rPar);
        }
        List<Token> commaTokens = commas.stream().map(AstNode::getToken).collect(Collectors.toList());
        return new PyTupleTreeImpl(atom, lPar, expressionList.expressions(), commaTokens, rPar);
    }

    private PyConditionalExpressionTree conditionalExpression(AstNode astNode) {
        List children = astNode.getChildren();
        PyExpressionTree trueExpression = this.expression((AstNode)children.get(0));
        Token ifToken = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.IF}).getToken();
        PyExpressionTree condition = this.expression((AstNode)children.get(2));
        Token elseToken = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE}).getToken();
        PyExpressionTree falseExpression = this.expression((AstNode)children.get(4));
        return new PyConditionalExpressionTreeImpl(astNode, trueExpression, ifToken, condition, elseToken, falseExpression);
    }

    private PyExpressionTree powerExpression(AstNode astNode) {
        AstNode powerOperator;
        PyExpressionTree expr = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CALL_EXPR, PythonGrammar.ATTRIBUTE_REF, PythonGrammar.ATOM}));
        for (AstNode trailer : astNode.getChildren(new AstNodeType[]{PythonGrammar.TRAILER})) {
            expr = this.withTrailer(expr, trailer);
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{GenericTokenType.IDENTIFIER})) {
            expr = new PyAwaitExpressionTreeImpl(astNode, astNode.getFirstChild().getToken(), expr);
        }
        if ((powerOperator = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL})) != null) {
            expr = new PyBinaryExpressionTreeImpl(expr, powerOperator.getToken(), this.expression(powerOperator.getNextSibling()));
        }
        return expr;
    }

    private PyExpressionTree withTrailer(PyExpressionTree expr, AstNode trailer) {
        AstNode firstChild = trailer.getFirstChild();
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            AstNode argListNode = trailer.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
            return new PyCallExpressionTreeImpl(expr, this.argList(argListNode), firstChild, trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}));
        }
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.LBRACKET})) {
            Token leftBracket = trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken();
            Token rightBracket = trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken();
            return this.subscriptionOrSlicing(expr, leftBracket, trailer.getFirstChild(new AstNodeType[]{PythonGrammar.SUBSCRIPTLIST}), rightBracket);
        }
        PyNameTree name = PythonTreeMaker.name(trailer.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        return new PyQualifiedExpressionTreeImpl(trailer, name, expr, trailer.getFirstChild(new AstNodeType[]{PythonPunctuator.DOT}).getToken());
    }

    private PyExpressionTree subscriptionOrSlicing(PyExpressionTree expr, Token leftBracket, AstNode subscriptList, Token rightBracket) {
        ArrayList<Tree> slices = new ArrayList<Tree>();
        for (AstNode subscript : subscriptList.getChildren(new AstNodeType[]{PythonGrammar.SUBSCRIPT})) {
            AstNode colon = subscript.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
            if (colon == null) {
                slices.add(this.expression(subscript.getFirstChild(new AstNodeType[]{PythonGrammar.TEST})));
                continue;
            }
            slices.add(this.sliceItem(subscript));
        }
        if (slices.stream().anyMatch(s -> Tree.Kind.SLICE_ITEM.equals((Object)s.getKind()))) {
            List<Token> separators = subscriptList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA}).stream().map(AstNode::getToken).collect(Collectors.toList());
            PySliceListTreeImpl sliceList = new PySliceListTreeImpl(subscriptList, slices, separators);
            return new PySliceExpressionTreeImpl(expr, leftBracket, sliceList, rightBracket);
        }
        List<PyExpressionTree> expressions = slices.stream().map(PyExpressionTree.class::cast).collect(Collectors.toList());
        PyExpressionListTreeImpl subscripts = new PyExpressionListTreeImpl(expressions);
        return new PySubscriptionExpressionTreeImpl(expr, leftBracket, subscripts, rightBracket);
    }

    PySliceItemTree sliceItem(AstNode subscript) {
        AstNode boundSeparator = subscript.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON});
        PyExpressionTree lowerBound = this.sliceBound(boundSeparator.getPreviousSibling());
        PyExpressionTree upperBound = this.sliceBound(boundSeparator.getNextSibling());
        AstNode strideNode = subscript.getFirstChild(new AstNodeType[]{PythonGrammar.SLICEOP});
        Token strideSeparator = strideNode == null ? null : strideNode.getToken();
        PyExpressionTree stride = null;
        if (strideNode != null && strideNode.hasDirectChildren(new AstNodeType[]{PythonGrammar.TEST})) {
            stride = this.expression(strideNode.getLastChild());
        }
        return new PySliceItemTreeImpl(subscript, lowerBound, boundSeparator.getToken(), upperBound, strideSeparator, stride);
    }

    @CheckForNull
    private PyExpressionTree sliceBound(@Nullable AstNode node) {
        if (node == null || !node.is(new AstNodeType[]{PythonGrammar.TEST})) {
            return null;
        }
        return this.expression(node);
    }

    private PyExpressionTree listLiteral(AstNode astNode) {
        PyExpressionListTree elements;
        Token leftBracket = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LBRACKET}).getToken();
        Token rightBracket = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RBRACKET}).getToken();
        AstNode testListComp = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST_COMP});
        if (testListComp != null) {
            AstNode compForNode = testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
            if (compForNode != null) {
                PyExpressionTree resultExpression = this.expression(testListComp.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.STAR_EXPR}));
                return new PyComprehensionExpressionTreeImpl(Tree.Kind.LIST_COMPREHENSION, leftBracket, resultExpression, this.compFor(compForNode), rightBracket);
            }
            elements = this.expressionList(testListComp);
        } else {
            elements = new PyExpressionListTreeImpl(astNode, Collections.emptyList());
        }
        return new PyListLiteralTreeImpl(astNode, leftBracket, elements, rightBracket);
    }

    private PyComprehensionForTree compFor(AstNode compFor) {
        PyExpressionTree expression = this.exprListOrTestList(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}));
        Token forToken = compFor.getFirstChild(new AstNodeType[]{PythonKeyword.FOR}).getToken();
        Token inToken = compFor.getFirstChild(new AstNodeType[]{PythonKeyword.IN}).getToken();
        PyExpressionTree iterable = this.exprListOrTestList(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}));
        PyComprehensionClauseTree nested = this.compClause(compFor.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_ITER}));
        return new PyComprehensionForTreeImpl(compFor, forToken, expression, inToken, iterable, nested);
    }

    @CheckForNull
    private PyComprehensionClauseTree compClause(@Nullable AstNode node) {
        if (node == null) {
            return null;
        }
        AstNode child = node.getFirstChild();
        if (child.is(new AstNodeType[]{PythonGrammar.COMP_FOR})) {
            return this.compFor(child);
        }
        PyExpressionTree condition = this.expression(child.getFirstChild(new AstNodeType[]{PythonGrammar.TEST_NOCOND}));
        PyComprehensionClauseTree nestedClause = this.compClause(child.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_ITER}));
        Token ifToken = child.getFirstChild(new AstNodeType[]{PythonKeyword.IF}).getToken();
        return new PyComprehensionIfTreeImpl(child, ifToken, condition, nestedClause);
    }

    public PyQualifiedExpressionTree qualifiedExpression(AstNode astNode) {
        PyExpressionTree qualifier = this.expression(astNode.getFirstChild());
        List names = astNode.getChildren(new AstNodeType[]{PythonGrammar.NAME});
        AstNode lastNameNode = astNode.getLastChild();
        for (AstNode nameNode : names) {
            if (nameNode == lastNameNode) continue;
            qualifier = new PyQualifiedExpressionTreeImpl(astNode, PythonTreeMaker.name(nameNode), qualifier, nameNode.getPreviousSibling().getToken());
        }
        return new PyQualifiedExpressionTreeImpl(astNode, PythonTreeMaker.name(lastNameNode), qualifier, lastNameNode.getPreviousSibling().getToken());
    }

    public PyCallExpressionTree callExpression(AstNode astNode) {
        PyExpressionTree callee = this.expression(astNode.getFirstChild());
        AstNode argListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        PyArgListTree argumentList = this.argList(argListNode);
        if (argumentList != null) {
            PythonTreeMaker.checkGeneratorExpressionInArgument(argumentList.arguments());
        }
        return new PyCallExpressionTreeImpl(astNode, callee, argumentList, astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.LPARENTHESIS}), astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.RPARENTHESIS}));
    }

    @CheckForNull
    private PyArgListTree argList(@Nullable AstNode argList) {
        if (argList != null) {
            List<PyArgumentTree> arguments = argList.getChildren(new AstNodeType[]{PythonGrammar.ARGUMENT}).stream().map(this::argument).collect(Collectors.toList());
            return new PyArgListTreeImpl(argList, arguments);
        }
        return null;
    }

    private static void checkGeneratorExpressionInArgument(List<PyArgumentTree> arguments) {
        List nonParenthesizedGeneratorExpressions = arguments.stream().filter(arg -> arg.expression().is(Tree.Kind.GENERATOR_EXPR) && !arg.expression().firstToken().getValue().equals("(")).collect(Collectors.toList());
        if (!nonParenthesizedGeneratorExpressions.isEmpty() && arguments.size() > 1) {
            int line = ((PyArgumentTree)nonParenthesizedGeneratorExpressions.get(0)).firstToken().getLine();
            throw new RecognitionException(line, "Parse error at line " + line + ": Generator expression must be parenthesized if not sole argument.");
        }
    }

    public PyArgumentTree argument(AstNode astNode) {
        AstNode compFor = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.COMP_FOR});
        if (compFor != null) {
            PyExpressionTree expression = this.expression(astNode.getFirstChild());
            PyComprehensionExpressionTreeImpl comprehension = new PyComprehensionExpressionTreeImpl(Tree.Kind.GENERATOR_EXPR, expression.firstToken(), expression, this.compFor(compFor), compFor.getLastToken());
            return new PyArgumentTreeImpl(astNode, comprehension, null, null);
        }
        AstNode assign = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.ASSIGN});
        AstNode star = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL});
        AstNode starStar = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.MUL_MUL});
        PyExpressionTree arg = this.expression(astNode.getLastChild(new AstNodeType[]{PythonGrammar.TEST}));
        if (assign != null) {
            AstNode nameNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}).getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}).getFirstChild(new AstNodeType[]{PythonGrammar.NAME});
            return new PyArgumentTreeImpl(astNode, PythonTreeMaker.name(nameNode), arg, assign.getToken(), star, starStar);
        }
        return new PyArgumentTreeImpl(astNode, arg, star, starStar);
    }

    private PyExpressionTree binaryExpression(AstNode astNode) {
        List children = astNode.getChildren();
        PyExpressionTree result = this.expression((AstNode)children.get(0));
        for (int i = 1; i < astNode.getNumberOfChildren(); i += 2) {
            Token notToken;
            AstNode operator = (AstNode)children.get(i);
            PyExpressionTree rightOperand = this.expression(operator.getNextSibling());
            AstNode not = operator.getFirstChild(new AstNodeType[]{PythonKeyword.NOT});
            Token token = notToken = not == null ? null : not.getToken();
            result = PythonKeyword.IN.equals(operator.getLastToken().getType()) ? new PyInExpressionTreeImpl(result, notToken, operator.getLastToken(), rightOperand) : (PythonKeyword.IS.equals(operator.getToken().getType()) ? new PyIsExpressionTreeImpl(result, operator.getToken(), notToken, rightOperand) : new PyBinaryExpressionTreeImpl(result, operator.getToken(), rightOperand));
        }
        return result;
    }

    public PyLambdaExpressionTree lambdaExpression(AstNode astNode) {
        Token lambdaKeyword = astNode.getFirstChild(new AstNodeType[]{PythonKeyword.LAMBDA}).getToken();
        Token colonToken = astNode.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken();
        PyExpressionTree body = this.expression(astNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST, PythonGrammar.TEST_NOCOND}));
        AstNode varArgsListNode = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.VARARGSLIST});
        PyParameterListTreeImpl argListTree = null;
        if (varArgsListNode != null) {
            List<PyAnyParameterTree> parameters = varArgsListNode.getChildren(new AstNodeType[]{PythonGrammar.FPDEF, PythonGrammar.NAME}).stream().map(this::parameter).collect(Collectors.toList());
            argListTree = new PyParameterListTreeImpl(varArgsListNode, parameters);
        }
        return new PyLambdaExpressionTreeImpl(astNode, lambdaKeyword, colonToken, body, argListTree);
    }

    private PyAnyParameterTree parameter(AstNode parameter) {
        AstNode prevSibling = parameter.getPreviousSibling();
        if (parameter.is(new AstNodeType[]{PythonGrammar.NAME})) {
            return new PyParameterTreeImpl(parameter, prevSibling.getToken(), PythonTreeMaker.name(parameter), null, null, null);
        }
        AstNode paramList = parameter.getFirstChild(new AstNodeType[]{PythonGrammar.TFPLIST, PythonGrammar.FPLIST});
        if (paramList != null) {
            List<PyAnyParameterTree> params = paramList.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF, PythonGrammar.FPDEF}).stream().map(this::parameter).collect(Collectors.toList());
            List<Token> commas = paramList.getChildren(new AstNodeType[]{PythonPunctuator.COMMA}).stream().map(AstNode::getToken).collect(Collectors.toList());
            return new PyTupleParameterTreeImpl(parameter, params, commas);
        }
        Token starOrStarStar = null;
        if (prevSibling != null && prevSibling.is(new AstNodeType[]{PythonPunctuator.MUL, PythonPunctuator.MUL_MUL})) {
            starOrStarStar = prevSibling.getToken();
        }
        PyNameTree name = PythonTreeMaker.name(parameter.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}));
        AstNode nextSibling = parameter.getNextSibling();
        Token assignToken = null;
        PyExpressionTree defaultValue = null;
        if (nextSibling != null && nextSibling.is(new AstNodeType[]{PythonPunctuator.ASSIGN})) {
            assignToken = nextSibling.getToken();
            defaultValue = this.expression(nextSibling.getNextSibling());
        }
        PyTypeAnnotationTreeImpl typeAnnotation = null;
        AstNode testNode = parameter.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
        if (testNode != null) {
            Token colonToken = parameter.getFirstChild(new AstNodeType[]{PythonPunctuator.COLON}).getToken();
            typeAnnotation = new PyTypeAnnotationTreeImpl(colonToken, this.expression(testNode));
        }
        return new PyParameterTreeImpl(parameter, starOrStarStar, name, typeAnnotation, assignToken, defaultValue);
    }

    private static PyExpressionTree numericLiteral(AstNode astNode) {
        return new PyNumericLiteralTreeImpl(astNode);
    }

    private static PyExpressionTree stringLiteral(AstNode astNode) {
        List<PyStringElementTree> stringElements = astNode.getChildren(new AstNodeType[]{PythonTokenType.STRING}).stream().map(PyStringElementImpl::new).collect(Collectors.toList());
        return new PyStringLiteralTreeImpl(astNode, stringElements);
    }
}

