/*
 * SonarQube Python Plugin
 * Copyright (C) 2011-2019 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.Tree;

public class QualifiedExpressionImpl extends PyTree implements QualifiedExpression {
  private final Name name;
  private final Expression qualifier;
  private final Token dotToken;
  private final AstNode astNode;

  public QualifiedExpressionImpl(AstNode astNode, Name name, Expression qualifier, Token dotToken) {
    super(qualifier.firstToken(), name.lastToken());
    // FIXME : astNode is required to make semantic work at function level, this should disappear once semantic relies on strongly typed AST.
    this.astNode = astNode;
    this.name = name;
    this.qualifier = qualifier;
    this.dotToken = dotToken;
  }

  @CheckForNull
  @Override
  public AstNode astNode() {
    return astNode;
  }

  @Override
  public Expression qualifier() {
    return qualifier;
  }

  @Override
  public Token dotToken() {
    return dotToken;
  }

  @Override
  public Name name() {
    return name;
  }

  @Override
  public Kind getKind() {
    return Kind.QUALIFIED_EXPR;
  }

  @Override
  public void accept(TreeVisitor visitor) {
    visitor.visitQualifiedExpression(this);
  }

  @Override
  public List<Tree> children() {
    return Stream.of(name, dotToken, qualifier).collect(Collectors.toList());
  }
}
