/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;

public abstract class IssueLocation {
    public static final int UNDEFINED_OFFSET = -1;
    public static final int UNDEFINED_LINE = 0;
    private String message;

    private IssueLocation(@Nullable String message) {
        this.message = message;
    }

    public static IssueLocation atFileLevel(String message) {
        return new FileLevelIssueLocation(message);
    }

    public static IssueLocation atLineLevel(String message, int lineNumber) {
        return new LineLevelIssueLocation(message, lineNumber);
    }

    public static IssueLocation preciseLocation(AstNode startNode, AstNode endNode, String message) {
        return new PreciseIssueLocation(startNode, endNode, message);
    }

    public static IssueLocation preciseLocation(AstNode startNode, @Nullable String message) {
        return new PreciseIssueLocation(startNode, message);
    }

    public static IssueLocation preciseLocation(Tree tree, @Nullable String message) {
        return new PreciseIssueLocation(tree.firstToken(), tree.lastToken(), message);
    }

    public static IssueLocation preciseLocation(Token token, @Nullable String message) {
        return new PreciseIssueLocation(token, message);
    }

    public static IssueLocation preciseLocation(Token from, Token to, @Nullable String message) {
        return new PreciseIssueLocation(from, to, message);
    }

    @CheckForNull
    public String message() {
        return this.message;
    }

    public abstract int startLine();

    public abstract int startLineOffset();

    public abstract int endLine();

    public abstract int endLineOffset();

    private static class FileLevelIssueLocation
    extends IssueLocation {
        public FileLevelIssueLocation(String message) {
            super(message);
        }

        @Override
        public int startLine() {
            return 0;
        }

        @Override
        public int startLineOffset() {
            return -1;
        }

        @Override
        public int endLine() {
            return 0;
        }

        @Override
        public int endLineOffset() {
            return -1;
        }
    }

    private static class LineLevelIssueLocation
    extends IssueLocation {
        private final int lineNumber;

        public LineLevelIssueLocation(String message, int lineNumber) {
            super(message);
            this.lineNumber = lineNumber;
        }

        @Override
        public int startLine() {
            return this.lineNumber;
        }

        @Override
        public int startLineOffset() {
            return -1;
        }

        @Override
        public int endLine() {
            return this.lineNumber;
        }

        @Override
        public int endLineOffset() {
            return -1;
        }
    }

    private static class PreciseIssueLocation
    extends IssueLocation {
        private final com.sonar.sslr.api.Token firstToken;
        private final TokenLocation lastTokenLocation;

        public PreciseIssueLocation(AstNode node, @Nullable String message) {
            super(message);
            this.firstToken = node.getToken();
            this.lastTokenLocation = new TokenLocation(node.getLastToken());
        }

        public PreciseIssueLocation(AstNode startNode, AstNode endNode, String message) {
            super(message);
            this.firstToken = startNode.getToken();
            this.lastTokenLocation = new TokenLocation(endNode.getLastToken());
        }

        public PreciseIssueLocation(Token firstToken, Token lastToken, @Nullable String message) {
            super(message);
            this.firstToken = firstToken.token();
            this.lastTokenLocation = new TokenLocation(lastToken.token());
        }

        public PreciseIssueLocation(Token token, @Nullable String message) {
            super(message);
            this.firstToken = token.token();
            this.lastTokenLocation = new TokenLocation(token.token());
        }

        @Override
        public int startLine() {
            return this.firstToken.getLine();
        }

        @Override
        public int startLineOffset() {
            return this.firstToken.getColumn();
        }

        @Override
        public int endLine() {
            return this.lastTokenLocation.endLine();
        }

        @Override
        public int endLineOffset() {
            return this.lastTokenLocation.endLineOffset();
        }
    }
}

