/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonFile;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.BaseTreeVisitor;

public class SubscriptionVisitor
extends BaseTreeVisitor {
    private final EnumMap<Tree.Kind, List<SubscriptionContextImpl>> consumers = new EnumMap(Tree.Kind.class);
    private final PythonVisitorContext pythonVisitorContext;
    private Tree currentElement;

    public static void analyze(Collection<PythonSubscriptionCheck> checks, PythonVisitorContext pythonVisitorContext) {
        SubscriptionVisitor subscriptionVisitor = new SubscriptionVisitor(checks, pythonVisitorContext);
        FileInput rootTree = pythonVisitorContext.rootTree();
        if (rootTree != null) {
            subscriptionVisitor.scan(rootTree);
            checks.forEach(PythonSubscriptionCheck::leaveFile);
        }
    }

    private SubscriptionVisitor(Collection<PythonSubscriptionCheck> checks, PythonVisitorContext pythonVisitorContext) {
        this.pythonVisitorContext = pythonVisitorContext;
        for (PythonSubscriptionCheck check : checks) {
            check.initialize((elementType, consumer) -> {
                List elementConsumers = this.consumers.computeIfAbsent(elementType, c -> new ArrayList());
                elementConsumers.add(new SubscriptionContextImpl(check, consumer));
            });
        }
    }

    @Override
    public void scan(@Nullable Tree element) {
        if (element != null) {
            this.currentElement = element;
            this.consumers.getOrDefault((Object)element.getKind(), Collections.emptyList()).forEach(SubscriptionContextImpl::execute);
        }
        super.scan(element);
    }

    private class SubscriptionContextImpl
    implements SubscriptionContext {
        private final PythonCheck check;
        private final Consumer<SubscriptionContext> consumer;

        SubscriptionContextImpl(PythonCheck check, Consumer<SubscriptionContext> consumer) {
            this.check = check;
            this.consumer = consumer;
        }

        public void execute() {
            this.consumer.accept(this);
        }

        @Override
        public Tree syntaxNode() {
            return SubscriptionVisitor.this.currentElement;
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(Tree element, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(element, message));
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(Token token, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(token, message));
        }

        @Override
        public PythonCheck.PreciseIssue addIssue(Token from, Token to, @Nullable String message) {
            return this.addIssue(IssueLocation.preciseLocation(from, to, message));
        }

        @Override
        public PythonCheck.PreciseIssue addFileIssue(String message) {
            return this.addIssue(IssueLocation.atFileLevel(message));
        }

        @Override
        public PythonCheck.PreciseIssue addLineIssue(String message, int lineNumber) {
            return this.addIssue(IssueLocation.atLineLevel(message, lineNumber));
        }

        private PythonCheck.PreciseIssue addIssue(IssueLocation issueLocation) {
            PythonCheck.PreciseIssue newIssue = new PythonCheck.PreciseIssue(this.check, issueLocation);
            SubscriptionVisitor.this.pythonVisitorContext.addIssue(newIssue);
            return newIssue;
        }

        @Override
        public PythonFile pythonFile() {
            return SubscriptionVisitor.this.pythonVisitorContext.pythonFile();
        }
    }
}

