/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.api.tree;

import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.AliasedName;
import org.sonar.python.api.tree.AnnotatedAssignment;
import org.sonar.python.api.tree.ArgList;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.AssertStatement;
import org.sonar.python.api.tree.AssignmentStatement;
import org.sonar.python.api.tree.AwaitExpression;
import org.sonar.python.api.tree.BinaryExpression;
import org.sonar.python.api.tree.BreakStatement;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.CompoundAssignmentStatement;
import org.sonar.python.api.tree.ComprehensionExpression;
import org.sonar.python.api.tree.ComprehensionFor;
import org.sonar.python.api.tree.ComprehensionIf;
import org.sonar.python.api.tree.ConditionalExpression;
import org.sonar.python.api.tree.ContinueStatement;
import org.sonar.python.api.tree.Decorator;
import org.sonar.python.api.tree.DelStatement;
import org.sonar.python.api.tree.DictCompExpression;
import org.sonar.python.api.tree.DictionaryLiteral;
import org.sonar.python.api.tree.DottedName;
import org.sonar.python.api.tree.EllipsisExpression;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.ExceptClause;
import org.sonar.python.api.tree.ExecStatement;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.ExpressionStatement;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.FinallyClause;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.GlobalStatement;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.ImportFrom;
import org.sonar.python.api.tree.InExpression;
import org.sonar.python.api.tree.IsExpression;
import org.sonar.python.api.tree.KeyValuePair;
import org.sonar.python.api.tree.LambdaExpression;
import org.sonar.python.api.tree.ListLiteral;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.NoneExpression;
import org.sonar.python.api.tree.NonlocalStatement;
import org.sonar.python.api.tree.NumericLiteral;
import org.sonar.python.api.tree.Parameter;
import org.sonar.python.api.tree.ParameterList;
import org.sonar.python.api.tree.ParenthesizedExpression;
import org.sonar.python.api.tree.PassStatement;
import org.sonar.python.api.tree.PrintStatement;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.RaiseStatement;
import org.sonar.python.api.tree.ReprExpression;
import org.sonar.python.api.tree.ReturnStatement;
import org.sonar.python.api.tree.SetLiteral;
import org.sonar.python.api.tree.SliceExpression;
import org.sonar.python.api.tree.SliceItem;
import org.sonar.python.api.tree.SliceList;
import org.sonar.python.api.tree.StarredExpression;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.StringElement;
import org.sonar.python.api.tree.StringLiteral;
import org.sonar.python.api.tree.SubscriptionExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.TryStatement;
import org.sonar.python.api.tree.Tuple;
import org.sonar.python.api.tree.TupleParameter;
import org.sonar.python.api.tree.TypeAnnotation;
import org.sonar.python.api.tree.UnaryExpression;
import org.sonar.python.api.tree.WhileStatement;
import org.sonar.python.api.tree.WithItem;
import org.sonar.python.api.tree.WithStatement;
import org.sonar.python.api.tree.YieldExpression;
import org.sonar.python.api.tree.YieldStatement;

public interface Tree {
    public void accept(TreeVisitor var1);

    public boolean is(Kind var1);

    @CheckForNull
    @Deprecated
    public AstNode astNode();

    public Token firstToken();

    public Token lastToken();

    public Tree parent();

    public List<Tree> children();

    public Kind getKind();

    default public Stream<Tree> descendants(Kind kind) {
        return this.descendants().filter(tree -> tree.is(kind));
    }

    default public Stream<Tree> descendants() {
        return this.children().stream().filter(Objects::nonNull).flatMap(tree -> Stream.concat(Stream.of(tree), tree.descendants()));
    }

    default public List<Tree> ancestors() {
        ArrayList<Tree> ancestors = new ArrayList<Tree>();
        for (Tree currentParent = this.parent(); currentParent != null; currentParent = currentParent.parent()) {
            ancestors.add(currentParent);
        }
        return ancestors;
    }

    public static enum Kind {
        ALIASED_NAME(AliasedName.class),
        ARGUMENT(Argument.class),
        ARG_LIST(ArgList.class),
        ANNOTATED_ASSIGNMENT(AnnotatedAssignment.class),
        ASSERT_STMT(AssertStatement.class),
        ASSIGNMENT_STMT(AssignmentStatement.class),
        BREAK_STMT(BreakStatement.class),
        CALL_EXPR(CallExpression.class),
        CLASSDEF(ClassDef.class),
        CONDITIONAL_EXPR(ConditionalExpression.class),
        CONTINUE_STMT(ContinueStatement.class),
        COMPOUND_ASSIGNMENT(CompoundAssignmentStatement.class),
        DICTIONARY_LITERAL(DictionaryLiteral.class),
        DECORATOR(Decorator.class),
        DEL_STMT(DelStatement.class),
        DOTTED_NAME(DottedName.class),
        ELLIPSIS(EllipsisExpression.class),
        ELSE_STMT(ElseStatement.class),
        EXCEPT_CLAUSE(ExceptClause.class),
        EXEC_STMT(ExecStatement.class),
        EXPRESSION_LIST(ExpressionList.class),
        EXPRESSION_STMT(ExpressionStatement.class),
        FILE_INPUT(FileInput.class),
        FINALLY_CLAUSE(FinallyClause.class),
        FOR_STMT(ForStatement.class),
        FUNCDEF(FunctionDef.class),
        GLOBAL_STMT(GlobalStatement.class),
        IF_STMT(IfStatement.class),
        IMPORT_FROM(ImportFrom.class),
        IMPORT_NAME(DottedName.class),
        IMPORT_STMT(DottedName.class),
        LAMBDA(LambdaExpression.class),
        LIST_LITERAL(ListLiteral.class),
        NAME(Name.class),
        NONLOCAL_STMT(NonlocalStatement.class),
        NONE(NoneExpression.class),
        NUMERIC_LITERAL(NumericLiteral.class),
        PASS_STMT(PassStatement.class),
        PRINT_STMT(PrintStatement.class),
        QUALIFIED_EXPR(QualifiedExpression.class),
        RAISE_STMT(RaiseStatement.class),
        REPR(ReprExpression.class),
        RETURN_STMT(ReturnStatement.class),
        SET_LITERAL(SetLiteral.class),
        STATEMENT_LIST(StatementList.class),
        STRING_LITERAL(StringLiteral.class),
        STRING_ELEMENT(StringElement.class),
        TRY_STMT(TryStatement.class),
        PARAMETER(Parameter.class),
        TUPLE_PARAMETER(TupleParameter.class),
        TYPE_ANNOTATION(TypeAnnotation.class),
        RETURN_TYPE_ANNOTATION(TypeAnnotation.class),
        PARAMETER_LIST(ParameterList.class),
        WHILE_STMT(WhileStatement.class),
        WITH_ITEM(WithItem.class),
        WITH_STMT(WithStatement.class),
        YIELD_EXPR(YieldExpression.class),
        YIELD_STMT(YieldStatement.class),
        PARENTHESIZED(ParenthesizedExpression.class),
        STARRED_EXPR(StarredExpression.class),
        AWAIT(AwaitExpression.class),
        TUPLE(Tuple.class),
        DICT_COMPREHENSION(DictCompExpression.class),
        LIST_COMPREHENSION(ComprehensionExpression.class),
        SET_COMPREHENSION(ComprehensionExpression.class),
        GENERATOR_EXPR(ComprehensionExpression.class),
        COMP_FOR(ComprehensionFor.class),
        COMP_IF(ComprehensionIf.class),
        SUBSCRIPTION(SubscriptionExpression.class),
        SLICE_EXPR(SliceExpression.class),
        SLICE_LIST(SliceList.class),
        SLICE_ITEM(SliceItem.class),
        PLUS(BinaryExpression.class),
        MINUS(BinaryExpression.class),
        MULTIPLICATION(BinaryExpression.class),
        DIVISION(BinaryExpression.class),
        FLOOR_DIVISION(BinaryExpression.class),
        MODULO(BinaryExpression.class),
        MATRIX_MULTIPLICATION(BinaryExpression.class),
        SHIFT_EXPR(BinaryExpression.class),
        BITWISE_AND(BinaryExpression.class),
        BITWISE_OR(BinaryExpression.class),
        BITWISE_XOR(BinaryExpression.class),
        AND(BinaryExpression.class),
        OR(BinaryExpression.class),
        COMPARISON(BinaryExpression.class),
        POWER(BinaryExpression.class),
        IN(InExpression.class),
        IS(IsExpression.class),
        UNARY_PLUS(UnaryExpression.class),
        UNARY_MINUS(UnaryExpression.class),
        BITWISE_COMPLEMENT(UnaryExpression.class),
        NOT(UnaryExpression.class),
        KEY_VALUE_PAIR(KeyValuePair.class),
        TOKEN(Token.class);

        final Class<? extends Tree> associatedInterface;

        private Kind(Class<? extends Tree> associatedInterface) {
            this.associatedInterface = associatedInterface;
        }
    }
}

