/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.BinaryExpression;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.ConditionalExpression;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.ExceptClause;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.ReturnStatement;
import org.sonar.python.api.tree.Statement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.WhileStatement;
import org.sonar.python.tree.BaseTreeVisitor;

public class CognitiveComplexityVisitor
extends BaseTreeVisitor {
    private int complexity = 0;
    private Deque<NestingLevel> nestingLevelStack = new LinkedList<NestingLevel>();
    private Set<Token> alreadyConsideredOperators = new HashSet<Token>();
    @Nullable
    private final SecondaryLocationConsumer secondaryLocationConsumer;

    CognitiveComplexityVisitor(@Nullable SecondaryLocationConsumer secondaryLocationConsumer) {
        this.secondaryLocationConsumer = secondaryLocationConsumer;
        this.nestingLevelStack.push(new NestingLevel());
    }

    public static int complexity(Tree tree, @Nullable SecondaryLocationConsumer secondaryLocationConsumer) {
        CognitiveComplexityVisitor visitor = new CognitiveComplexityVisitor(secondaryLocationConsumer);
        visitor.scan(tree);
        return visitor.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    @Override
    public void visitIfStatement(IfStatement pyIfStatementTree) {
        if (pyIfStatementTree.isElif()) {
            this.incrementWithoutNesting(pyIfStatementTree.keyword());
        } else {
            this.incrementWithNesting(pyIfStatementTree.keyword());
        }
        super.visitIfStatement(pyIfStatementTree);
    }

    @Override
    public void visitElseStatement(ElseStatement pyElseStatementTree) {
        this.incrementWithoutNesting(pyElseStatementTree.elseKeyword());
        super.visitElseStatement(pyElseStatementTree);
    }

    @Override
    public void visitWhileStatement(WhileStatement pyWhileStatementTree) {
        this.incrementWithNesting(pyWhileStatementTree.whileKeyword());
        if (pyWhileStatementTree.elseBody() != null) {
            this.incrementWithoutNesting(pyWhileStatementTree.elseKeyword());
        }
        super.visitWhileStatement(pyWhileStatementTree);
    }

    @Override
    public void visitForStatement(ForStatement pyForStatementTree) {
        this.incrementWithNesting(pyForStatementTree.forKeyword());
        if (pyForStatementTree.elseBody() != null) {
            this.incrementWithoutNesting(pyForStatementTree.elseKeyword());
        }
        super.visitForStatement(pyForStatementTree);
    }

    @Override
    public void visitExceptClause(ExceptClause exceptClause) {
        this.incrementWithNesting(exceptClause.exceptKeyword());
        super.visitExceptClause(exceptClause);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
        if (pyBinaryExpressionTree.is(Tree.Kind.AND) || pyBinaryExpressionTree.is(Tree.Kind.OR)) {
            if (this.alreadyConsideredOperators.contains(pyBinaryExpressionTree.operator())) {
                super.visitBinaryExpression(pyBinaryExpressionTree);
                return;
            }
            ArrayList<Token> operators = new ArrayList<Token>();
            CognitiveComplexityVisitor.flattenOperators(pyBinaryExpressionTree, operators);
            Token previous = null;
            for (Token operator : operators) {
                if (previous == null || !previous.type().equals(operator.type())) {
                    this.incrementWithoutNesting(pyBinaryExpressionTree.operator());
                }
                previous = operator;
                this.alreadyConsideredOperators.add(operator);
            }
        }
        super.visitBinaryExpression(pyBinaryExpressionTree);
    }

    private static void flattenOperators(BinaryExpression binaryExpression, List<Token> operators) {
        Expression left = binaryExpression.leftOperand();
        if (left.is(Tree.Kind.AND) || left.is(Tree.Kind.OR)) {
            CognitiveComplexityVisitor.flattenOperators((BinaryExpression)left, operators);
        }
        operators.add(binaryExpression.operator());
        Expression right = binaryExpression.rightOperand();
        if (right.is(Tree.Kind.AND) || right.is(Tree.Kind.OR)) {
            CognitiveComplexityVisitor.flattenOperators((BinaryExpression)right, operators);
        }
    }

    @Override
    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        this.nestingLevelStack.push(new NestingLevel(this.nestingLevelStack.peek(), pyFunctionDefTree));
        super.visitFunctionDef(pyFunctionDefTree);
        this.nestingLevelStack.pop();
    }

    @Override
    public void visitClassDef(ClassDef pyClassDefTree) {
        this.nestingLevelStack.push(new NestingLevel(this.nestingLevelStack.peek(), pyClassDefTree));
        super.visitClassDef(pyClassDefTree);
        this.nestingLevelStack.pop();
    }

    @Override
    public void visitStatementList(StatementList statementList) {
        if (CognitiveComplexityVisitor.isStmtListIncrementsNestingLevel(statementList)) {
            this.nestingLevelStack.peek().increment();
            super.visitStatementList(statementList);
            this.nestingLevelStack.peek().decrement();
        } else {
            super.visitStatementList(statementList);
        }
    }

    @Override
    public void visitConditionalExpression(ConditionalExpression pyConditionalExpressionTree) {
        this.incrementWithNesting(pyConditionalExpressionTree.ifKeyword());
        this.nestingLevelStack.peek().increment();
        super.visitConditionalExpression(pyConditionalExpressionTree);
        this.nestingLevelStack.peek().decrement();
    }

    private static boolean isStmtListIncrementsNestingLevel(StatementList statementListTree) {
        if (statementListTree.parent().is(Tree.Kind.FILE_INPUT)) {
            return false;
        }
        List<Tree.Kind> notIncrementingNestingKinds = Arrays.asList(Tree.Kind.TRY_STMT, Tree.Kind.FINALLY_CLAUSE, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF, Tree.Kind.WITH_STMT);
        return statementListTree.parent() != null && notIncrementingNestingKinds.stream().noneMatch(kind -> statementListTree.parent().is((Tree.Kind)((Object)kind)));
    }

    private void incrementWithNesting(Token secondaryLocation) {
        this.incrementComplexity(secondaryLocation, 1 + this.nestingLevelStack.peek().level());
    }

    private void incrementWithoutNesting(Token secondaryLocation) {
        this.incrementComplexity(secondaryLocation, 1);
    }

    private void incrementComplexity(Token secondaryLocation, int currentNodeComplexity) {
        if (this.secondaryLocationConsumer != null) {
            this.secondaryLocationConsumer.consume(secondaryLocation, CognitiveComplexityVisitor.secondaryMessage(currentNodeComplexity));
        }
        this.complexity += currentNodeComplexity;
    }

    private static String secondaryMessage(int complexity) {
        if (complexity == 1) {
            return "+1";
        }
        return String.format("+%s (incl %s for nesting)", complexity, complexity - 1);
    }

    private static class NestingLevel {
        @Nullable
        private Tree tree;
        private int level;

        private NestingLevel() {
            this.tree = null;
            this.level = 0;
        }

        private NestingLevel(NestingLevel parent, Tree tree) {
            this.tree = tree;
            this.level = tree.is(Tree.Kind.FUNCDEF) ? (parent.isWrapperFunction((FunctionDef)tree) ? parent.level : (parent.isFunction() ? parent.level + 1 : 0)) : 0;
        }

        private boolean isFunction() {
            return this.tree != null && this.tree.is(Tree.Kind.FUNCDEF);
        }

        private boolean isWrapperFunction(FunctionDef childFunction) {
            if (this.tree != null && this.tree.is(Tree.Kind.FUNCDEF)) {
                return ((FunctionDef)this.tree).body().statements().stream().filter(statement -> statement != childFunction).allMatch(NestingLevel::isSimpleReturn);
            }
            return false;
        }

        private static boolean isSimpleReturn(Statement statement) {
            if (statement.is(Tree.Kind.RETURN_STMT)) {
                ReturnStatement returnStatementTree = (ReturnStatement)statement;
                return returnStatementTree.expressions().size() == 1 && returnStatementTree.expressions().get(0).is(Tree.Kind.NAME);
            }
            return false;
        }

        private int level() {
            return this.level;
        }

        private void increment() {
            ++this.level;
        }

        private void decrement() {
            --this.level;
        }
    }

    public static interface SecondaryLocationConsumer {
        public void consume(Token var1, String var2);
    }
}

