/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.metrics.CognitiveComplexityVisitor;
import org.sonar.python.metrics.ComplexityVisitor;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.python.tree.BaseTreeVisitor;

public class FileMetrics {
    private int numberOfStatements;
    private int numberOfClasses;
    private final ComplexityVisitor complexityVisitor = new ComplexityVisitor();
    private final CognitiveComplexityVisitor cognitiveComplexityVisitor = new CognitiveComplexityVisitor(null);
    private final FileLinesVisitor fileLinesVisitor;
    private List<Integer> functionComplexities = new ArrayList<Integer>();

    public FileMetrics(PythonVisitorContext context, boolean ignoreHeaderComments) {
        AstNode rootTree = context.rootAstNode();
        FileInput fileInput = context.rootTree();
        this.numberOfStatements = rootTree.getDescendants(new AstNodeType[]{PythonGrammar.STATEMENT}).size();
        this.numberOfClasses = rootTree.getDescendants(new AstNodeType[]{PythonGrammar.CLASSDEF}).size();
        fileInput.accept(this.complexityVisitor);
        fileInput.accept(this.cognitiveComplexityVisitor);
        this.fileLinesVisitor = new FileLinesVisitor(ignoreHeaderComments);
        this.fileLinesVisitor.scanFile(context);
        fileInput.accept(new FunctionVisitor());
    }

    public int numberOfStatements() {
        return this.numberOfStatements;
    }

    public int numberOfFunctions() {
        return this.functionComplexities.size();
    }

    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    public int complexity() {
        return this.complexityVisitor.getComplexity();
    }

    public int cognitiveComplexity() {
        return this.cognitiveComplexityVisitor.getComplexity();
    }

    public List<Integer> functionComplexities() {
        return this.functionComplexities;
    }

    public FileLinesVisitor fileLinesVisitor() {
        return this.fileLinesVisitor;
    }

    private class FunctionVisitor
    extends BaseTreeVisitor {
        private FunctionVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            FileMetrics.this.functionComplexities.add(ComplexityVisitor.complexity(pyFunctionDefTree));
            super.visitFunctionDef(pyFunctionDefTree);
        }
    }
}

