/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.AnnotatedAssignment;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class AnnotatedAssignmentImpl
extends PyTree
implements AnnotatedAssignment {
    private final Expression variable;
    private final Token colonToken;
    private final Expression annotation;
    private final Token equalToken;
    private final Expression assignedValue;

    public AnnotatedAssignmentImpl(Expression variable, Token colonToken, Expression annotation, @Nullable Token equalToken, @Nullable Expression assignedValue) {
        super(variable.firstToken(), assignedValue != null ? assignedValue.lastToken() : annotation.lastToken());
        this.variable = variable;
        this.colonToken = colonToken;
        this.annotation = annotation;
        this.equalToken = equalToken;
        this.assignedValue = assignedValue;
    }

    @Override
    public Expression variable() {
        return this.variable;
    }

    @Override
    public Token colonToken() {
        return this.colonToken;
    }

    @Override
    public Expression annotation() {
        return this.annotation;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    @CheckForNull
    public Expression assignedValue() {
        return this.assignedValue;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAnnotatedAssignment(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.variable, this.colonToken, this.annotation, this.equalToken, this.assignedValue).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ANNOTATED_ASSIGNMENT;
    }
}

