/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ArgumentImpl
extends PyTree
implements Argument {
    private final Name keywordArgument;
    private final Expression expression;
    private final Token equalToken;
    private final Token star;
    private final Token starStar;

    public ArgumentImpl(AstNode node, Name keywordArgument, Expression expression, Token equalToken, @Nullable Token star, @Nullable Token starStar) {
        super(node);
        this.keywordArgument = keywordArgument;
        this.expression = expression;
        this.equalToken = equalToken;
        this.star = star;
        this.starStar = starStar;
    }

    public ArgumentImpl(AstNode astNode, Expression expression, @Nullable Token star, @Nullable Token starStar) {
        super(astNode);
        this.keywordArgument = null;
        this.expression = expression;
        this.equalToken = null;
        this.star = star;
        this.starStar = starStar;
    }

    @Override
    @CheckForNull
    public Name keywordArgument() {
        return this.keywordArgument;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    @CheckForNull
    public Token starToken() {
        return this.star;
    }

    @Override
    @CheckForNull
    public Token starStarToken() {
        return this.starStar;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArgument(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARGUMENT;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.keywordArgument, this.expression, this.equalToken, this.star, this.starStar).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

