/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.AssertStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class AssertStatementImpl
extends PyTree
implements AssertStatement {
    private final Token assertKeyword;
    private final Expression condition;
    @Nullable
    private final Expression message;

    public AssertStatementImpl(AstNode astNode, Token assertKeyword, Expression condition, @Nullable Expression message) {
        super(astNode);
        this.assertKeyword = assertKeyword;
        this.condition = condition;
        this.message = message;
    }

    @Override
    public Token assertKeyword() {
        return this.assertKeyword;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    @Nullable
    public Expression message() {
        return this.message;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ASSERT_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAssertStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.assertKeyword, this.condition, this.message).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

