/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.AssignmentStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class AssignmentStatementImpl
extends PyTree
implements AssignmentStatement {
    private final List<Token> assignTokens;
    private final List<ExpressionList> lhsExpressions;
    private final Expression assignedValue;

    public AssignmentStatementImpl(AstNode astNode, List<Token> assignTokens, List<ExpressionList> lhsExpressions, Expression assignedValue) {
        super(astNode);
        this.assignTokens = assignTokens;
        this.lhsExpressions = lhsExpressions;
        this.assignedValue = assignedValue;
    }

    @Override
    public Expression assignedValue() {
        return this.assignedValue;
    }

    @Override
    public List<Token> equalTokens() {
        return this.assignTokens;
    }

    @Override
    public List<ExpressionList> lhsExpressions() {
        return this.lhsExpressions;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAssignmentStatement(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ASSIGNMENT_STMT;
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.assignTokens, this.lhsExpressions, Collections.singletonList(this.assignedValue)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

