/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.AliasedName;
import org.sonar.python.api.tree.AnnotatedAssignment;
import org.sonar.python.api.tree.ArgList;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.AssertStatement;
import org.sonar.python.api.tree.AssignmentStatement;
import org.sonar.python.api.tree.AwaitExpression;
import org.sonar.python.api.tree.BinaryExpression;
import org.sonar.python.api.tree.BreakStatement;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.CompoundAssignmentStatement;
import org.sonar.python.api.tree.ComprehensionExpression;
import org.sonar.python.api.tree.ComprehensionFor;
import org.sonar.python.api.tree.ComprehensionIf;
import org.sonar.python.api.tree.ConditionalExpression;
import org.sonar.python.api.tree.ContinueStatement;
import org.sonar.python.api.tree.Decorator;
import org.sonar.python.api.tree.DelStatement;
import org.sonar.python.api.tree.DictionaryLiteral;
import org.sonar.python.api.tree.DottedName;
import org.sonar.python.api.tree.EllipsisExpression;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.ExceptClause;
import org.sonar.python.api.tree.ExecStatement;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.ExpressionStatement;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.FinallyClause;
import org.sonar.python.api.tree.ForStatement;
import org.sonar.python.api.tree.FunctionDef;
import org.sonar.python.api.tree.GlobalStatement;
import org.sonar.python.api.tree.IfStatement;
import org.sonar.python.api.tree.ImportFrom;
import org.sonar.python.api.tree.ImportName;
import org.sonar.python.api.tree.KeyValuePair;
import org.sonar.python.api.tree.LambdaExpression;
import org.sonar.python.api.tree.ListLiteral;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.NoneExpression;
import org.sonar.python.api.tree.NonlocalStatement;
import org.sonar.python.api.tree.NumericLiteral;
import org.sonar.python.api.tree.Parameter;
import org.sonar.python.api.tree.ParameterList;
import org.sonar.python.api.tree.ParenthesizedExpression;
import org.sonar.python.api.tree.PassStatement;
import org.sonar.python.api.tree.PrintStatement;
import org.sonar.python.api.tree.QualifiedExpression;
import org.sonar.python.api.tree.RaiseStatement;
import org.sonar.python.api.tree.ReprExpression;
import org.sonar.python.api.tree.ReturnStatement;
import org.sonar.python.api.tree.SetLiteral;
import org.sonar.python.api.tree.SliceExpression;
import org.sonar.python.api.tree.SliceItem;
import org.sonar.python.api.tree.SliceList;
import org.sonar.python.api.tree.StarredExpression;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.StringElement;
import org.sonar.python.api.tree.StringLiteral;
import org.sonar.python.api.tree.SubscriptionExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.api.tree.TryStatement;
import org.sonar.python.api.tree.Tuple;
import org.sonar.python.api.tree.TupleParameter;
import org.sonar.python.api.tree.TypeAnnotation;
import org.sonar.python.api.tree.UnaryExpression;
import org.sonar.python.api.tree.WhileStatement;
import org.sonar.python.api.tree.WithItem;
import org.sonar.python.api.tree.WithStatement;
import org.sonar.python.api.tree.YieldExpression;
import org.sonar.python.api.tree.YieldStatement;
import org.sonar.python.tree.DictCompExpressionImpl;

public class BaseTreeVisitor
implements TreeVisitor {
    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected void scan(@Nullable List<? extends Tree> trees) {
        if (trees != null) {
            for (Tree tree : trees) {
                this.scan(tree);
            }
        }
    }

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.scan(fileInput.statements());
    }

    @Override
    public void visitStatementList(StatementList statementList) {
        this.scan(statementList.statements());
    }

    @Override
    public void visitIfStatement(IfStatement pyIfStatementTree) {
        this.scan(pyIfStatementTree.condition());
        this.scan(pyIfStatementTree.body());
        this.scan(pyIfStatementTree.elifBranches());
        this.scan(pyIfStatementTree.elseBranch());
    }

    @Override
    public void visitElseStatement(ElseStatement pyElseStatementTree) {
        this.scan(pyElseStatementTree.body());
    }

    @Override
    public void visitExecStatement(ExecStatement pyExecStatementTree) {
        this.scan(pyExecStatementTree.expression());
        this.scan(pyExecStatementTree.globalsExpression());
        this.scan(pyExecStatementTree.localsExpression());
    }

    @Override
    public void visitAssertStatement(AssertStatement pyAssertStatementTree) {
        this.scan(pyAssertStatementTree.condition());
        this.scan(pyAssertStatementTree.message());
    }

    @Override
    public void visitDelStatement(DelStatement pyDelStatementTree) {
        this.scan(pyDelStatementTree.expressions());
    }

    @Override
    public void visitPassStatement(PassStatement pyPassStatementTree) {
    }

    @Override
    public void visitPrintStatement(PrintStatement pyPrintStatementTree) {
        this.scan(pyPrintStatementTree.expressions());
    }

    @Override
    public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
        this.scan(pyReturnStatementTree.expressions());
    }

    @Override
    public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
        this.scan(pyYieldStatementTree.yieldExpression());
    }

    @Override
    public void visitYieldExpression(YieldExpression pyYieldExpressionTree) {
        this.scan(pyYieldExpressionTree.expressions());
    }

    @Override
    public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
        this.scan(pyRaiseStatementTree.expressions());
        this.scan(pyRaiseStatementTree.fromExpression());
    }

    @Override
    public void visitBreakStatement(BreakStatement pyBreakStatementTree) {
    }

    @Override
    public void visitContinueStatement(ContinueStatement pyContinueStatementTree) {
    }

    @Override
    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        this.scan(pyFunctionDefTree.decorators());
        this.scan(pyFunctionDefTree.name());
        this.scan(pyFunctionDefTree.parameters());
        this.scan(pyFunctionDefTree.returnTypeAnnotation());
        this.scan(pyFunctionDefTree.body());
    }

    @Override
    public void visitName(Name pyNameTree) {
    }

    @Override
    public void visitClassDef(ClassDef pyClassDefTree) {
        this.scan(pyClassDefTree.name());
        this.scan(pyClassDefTree.args());
        this.scan(pyClassDefTree.body());
    }

    @Override
    public void visitAliasedName(AliasedName aliasedName) {
        this.scan(aliasedName.dottedName());
        this.scan(aliasedName.alias());
    }

    @Override
    public void visitDottedName(DottedName dottedName) {
        this.scan(dottedName.names());
    }

    @Override
    public void visitImportFrom(ImportFrom pyImportFromTree) {
        this.scan(pyImportFromTree.module());
        this.scan(pyImportFromTree.importedNames());
    }

    @Override
    public void visitForStatement(ForStatement pyForStatementTree) {
        this.scan(pyForStatementTree.expressions());
        this.scan(pyForStatementTree.testExpressions());
        this.scan(pyForStatementTree.body());
        this.scan(pyForStatementTree.elseBody());
    }

    @Override
    public void visitImportName(ImportName pyImportNameTree) {
        this.scan(pyImportNameTree.modules());
    }

    @Override
    public void visitGlobalStatement(GlobalStatement pyGlobalStatementTree) {
        this.scan(pyGlobalStatementTree.variables());
    }

    @Override
    public void visitNonlocalStatement(NonlocalStatement pyNonlocalStatementTree) {
        this.scan(pyNonlocalStatementTree.variables());
    }

    @Override
    public void visitWhileStatement(WhileStatement pyWhileStatementTree) {
        this.scan(pyWhileStatementTree.condition());
        this.scan(pyWhileStatementTree.body());
        this.scan(pyWhileStatementTree.elseBody());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement pyExpressionStatementTree) {
        this.scan(pyExpressionStatementTree.expressions());
    }

    @Override
    public void visitTryStatement(TryStatement pyTryStatementTree) {
        this.scan(pyTryStatementTree.body());
        this.scan(pyTryStatementTree.exceptClauses());
        this.scan(pyTryStatementTree.finallyClause());
        this.scan(pyTryStatementTree.elseClause());
    }

    @Override
    public void visitFinallyClause(FinallyClause finallyClause) {
        this.scan(finallyClause.body());
    }

    @Override
    public void visitExceptClause(ExceptClause exceptClause) {
        this.scan(exceptClause.exception());
        this.scan(exceptClause.exceptionInstance());
        this.scan(exceptClause.body());
    }

    @Override
    public void visitWithStatement(WithStatement pyWithStatementTree) {
        this.scan(pyWithStatementTree.withItems());
        this.scan(pyWithStatementTree.statements());
    }

    @Override
    public void visitWithItem(WithItem withItem) {
        this.scan(withItem.test());
        this.scan(withItem.expression());
    }

    @Override
    public void visitQualifiedExpression(QualifiedExpression pyQualifiedExpressionTree) {
        this.scan(pyQualifiedExpressionTree.qualifier());
        this.scan(pyQualifiedExpressionTree.name());
    }

    @Override
    public void visitCallExpression(CallExpression pyCallExpressionTree) {
        this.scan(pyCallExpressionTree.callee());
        this.scan(pyCallExpressionTree.argumentList());
    }

    @Override
    public void visitArgumentList(ArgList argList) {
        this.scan(argList.arguments());
    }

    @Override
    public void visitArgument(Argument pyArgumentTree) {
        this.scan(pyArgumentTree.keywordArgument());
        this.scan(pyArgumentTree.expression());
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
        this.scan(pyAssignmentStatementTree.lhsExpressions());
        this.scan(pyAssignmentStatementTree.assignedValue());
    }

    @Override
    public void visitExpressionList(ExpressionList pyExpressionListTree) {
        this.scan(pyExpressionListTree.expressions());
    }

    @Override
    public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
        this.scan(pyBinaryExpressionTree.leftOperand());
        this.scan(pyBinaryExpressionTree.rightOperand());
    }

    @Override
    public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
        this.scan(pyLambdaExpressionTree.parameters());
        this.scan(pyLambdaExpressionTree.expression());
    }

    @Override
    public void visitParameterList(ParameterList parameterList) {
        this.scan(parameterList.all());
    }

    @Override
    public void visitTupleParameter(TupleParameter tree) {
        this.scan(tree.parameters());
    }

    @Override
    public void visitParameter(Parameter tree) {
        this.scan(tree.name());
        this.scan(tree.typeAnnotation());
        this.scan(tree.defaultValue());
    }

    @Override
    public void visitTypeAnnotation(TypeAnnotation tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitNumericLiteral(NumericLiteral pyNumericLiteralTree) {
    }

    @Override
    public void visitStringLiteral(StringLiteral pyStringLiteralTree) {
        this.scan(pyStringLiteralTree.stringElements());
    }

    @Override
    public void visitStringElement(StringElement tree) {
    }

    @Override
    public void visitListLiteral(ListLiteral pyListLiteralTree) {
        this.scan(pyListLiteralTree.elements());
    }

    @Override
    public void visitUnaryExpression(UnaryExpression pyUnaryExpressionTree) {
        this.scan(pyUnaryExpressionTree.expression());
    }

    @Override
    public void visitStarredExpression(StarredExpression pyStarredExpressionTree) {
        this.scan(pyStarredExpressionTree.expression());
    }

    @Override
    public void visitAwaitExpression(AwaitExpression pyAwaitExpressionTree) {
        this.scan(pyAwaitExpressionTree.expression());
    }

    @Override
    public void visitSliceExpression(SliceExpression pySliceExpressionTree) {
        this.scan(pySliceExpressionTree.object());
        this.scan(pySliceExpressionTree.sliceList());
    }

    @Override
    public void visitSliceList(SliceList sliceList) {
        this.scan(sliceList.slices());
    }

    @Override
    public void visitSliceItem(SliceItem sliceItem) {
        this.scan(sliceItem.lowerBound());
        this.scan(sliceItem.upperBound());
        this.scan(sliceItem.stride());
    }

    @Override
    public void visitSubscriptionExpression(SubscriptionExpression pySubscriptionExpressionTree) {
        this.scan(pySubscriptionExpressionTree.object());
        this.scan(pySubscriptionExpressionTree.subscripts());
    }

    @Override
    public void visitParenthesizedExpression(ParenthesizedExpression pyParenthesizedExpressionTree) {
        this.scan(pyParenthesizedExpressionTree.expression());
    }

    @Override
    public void visitTuple(Tuple pyTupleTree) {
        this.scan(pyTupleTree.elements());
    }

    @Override
    public void visitConditionalExpression(ConditionalExpression pyConditionalExpressionTree) {
        this.scan(pyConditionalExpressionTree.condition());
        this.scan(pyConditionalExpressionTree.trueExpression());
        this.scan(pyConditionalExpressionTree.falseExpression());
    }

    @Override
    public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
        this.scan(tree.resultExpression());
        this.scan(tree.comprehensionFor());
    }

    @Override
    public void visitComprehensionFor(ComprehensionFor tree) {
        this.scan(tree.loopExpression());
        this.scan(tree.iterable());
        this.scan(tree.nestedClause());
    }

    @Override
    public void visitComprehensionIf(ComprehensionIf tree) {
        this.scan(tree.condition());
        this.scan(tree.nestedClause());
    }

    @Override
    public void visitDictionaryLiteral(DictionaryLiteral pyDictionaryLiteralTree) {
        this.scan(pyDictionaryLiteralTree.elements());
    }

    @Override
    public void visitSetLiteral(SetLiteral pySetLiteralTree) {
        this.scan(pySetLiteralTree.elements());
    }

    @Override
    public void visitKeyValuePair(KeyValuePair keyValuePair) {
        this.scan(keyValuePair.expression());
        this.scan(keyValuePair.key());
        this.scan(keyValuePair.value());
    }

    @Override
    public void visitDictCompExpression(DictCompExpressionImpl tree) {
        this.scan(tree.keyExpression());
        this.scan(tree.valueExpression());
        this.scan(tree.comprehensionFor());
    }

    @Override
    public void visitCompoundAssignment(CompoundAssignmentStatement pyCompoundAssignmentStatementTree) {
        this.scan(pyCompoundAssignmentStatementTree.lhsExpression());
        this.scan(pyCompoundAssignmentStatementTree.rhsExpression());
    }

    @Override
    public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
        this.scan(annotatedAssignment.variable());
        this.scan(annotatedAssignment.annotation());
        this.scan(annotatedAssignment.assignedValue());
    }

    @Override
    public void visitNone(NoneExpression pyNoneExpressionTree) {
    }

    @Override
    public void visitRepr(ReprExpression pyReprExpressionTree) {
        this.scan(pyReprExpressionTree.expressionList());
    }

    @Override
    public void visitEllipsis(EllipsisExpression pyEllipsisExpressionTree) {
    }

    @Override
    public void visitDecorator(Decorator decorator) {
        this.scan(decorator.name());
        this.scan(decorator.arguments());
    }

    @Override
    public void visitToken(Token token) {
    }
}

