/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.ArgList;
import org.sonar.python.api.tree.Argument;
import org.sonar.python.api.tree.CallExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class CallExpressionImpl
extends PyTree
implements CallExpression {
    private final Expression callee;
    private final ArgList argumentList;
    private final Token leftPar;
    private final Token rightPar;

    public CallExpressionImpl(AstNode astNode, Expression callee, @Nullable ArgList argumentList, Token leftPar, Token rightPar) {
        super(astNode);
        this.callee = callee;
        this.argumentList = argumentList;
        this.leftPar = leftPar;
        this.rightPar = rightPar;
    }

    public CallExpressionImpl(Expression callee, @Nullable ArgList argumentList, Token leftPar, Token rightPar) {
        super(callee.firstToken(), rightPar);
        this.callee = callee;
        this.argumentList = argumentList;
        this.leftPar = leftPar;
        this.rightPar = rightPar;
    }

    @Override
    public Expression callee() {
        return this.callee;
    }

    @Override
    public ArgList argumentList() {
        return this.argumentList;
    }

    @Override
    public List<Argument> arguments() {
        return this.argumentList != null ? this.argumentList.arguments() : Collections.emptyList();
    }

    @Override
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CALL_EXPR;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.callee, this.leftPar, this.argumentList, this.rightPar).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

