/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.ArgList;
import org.sonar.python.api.tree.ClassDef;
import org.sonar.python.api.tree.Decorator;
import org.sonar.python.api.tree.Name;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.tree.PyTree;

public class ClassDefImpl
extends PyTree
implements ClassDef {
    private final List<Decorator> decorators;
    private final Token classKeyword;
    private final Name name;
    private final Token leftPar;
    private final ArgList args;
    private final Token rightPar;
    private final Token colon;
    private final StatementList body;
    private final Token docstring;
    private final Set<Symbol> classFields = new HashSet<Symbol>();
    private final Set<Symbol> instanceFields = new HashSet<Symbol>();

    public ClassDefImpl(AstNode astNode, List<Decorator> decorators, Token classKeyword, Name name, @Nullable Token leftPar, @Nullable ArgList args, @Nullable Token rightPar, Token colon, StatementList body, Token docstring) {
        super(astNode);
        this.decorators = decorators;
        this.classKeyword = classKeyword;
        this.name = name;
        this.leftPar = leftPar;
        this.args = args;
        this.rightPar = rightPar;
        this.colon = colon;
        this.body = body;
        this.docstring = docstring;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CLASSDEF;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClassDef(this);
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public Token classKeyword() {
        return this.classKeyword;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    @CheckForNull
    public ArgList args() {
        return this.args;
    }

    @Override
    @CheckForNull
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token docstring() {
        return this.docstring;
    }

    @Override
    public Set<Symbol> classFields() {
        return this.classFields;
    }

    @Override
    public Set<Symbol> instanceFields() {
        return this.instanceFields;
    }

    public void addClassField(Symbol field) {
        this.classFields.add(field);
    }

    public void addInstanceField(Symbol field) {
        this.instanceFields.add(field);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.decorators, Arrays.asList(this.classKeyword, this.name, this.leftPar, this.args, this.rightPar, this.colon, this.body, this.docstring)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

