/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.CompoundAssignmentStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class CompoundAssignmentStatementImpl
extends PyTree
implements CompoundAssignmentStatement {
    private final Expression lhsExpression;
    private final Token augAssignToken;
    private final Expression rhsExpression;

    public CompoundAssignmentStatementImpl(AstNode astNode, Expression lhsExpression, Token augAssignToken, Expression rhsExpression) {
        super(astNode);
        this.lhsExpression = lhsExpression;
        this.augAssignToken = augAssignToken;
        this.rhsExpression = rhsExpression;
    }

    @Override
    public Expression rhsExpression() {
        return this.rhsExpression;
    }

    @Override
    public Token compoundAssignmentToken() {
        return this.augAssignToken;
    }

    @Override
    public Expression lhsExpression() {
        return this.lhsExpression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCompoundAssignment(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.lhsExpression, this.augAssignToken, this.rhsExpression).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.COMPOUND_ASSIGNMENT;
    }
}

