/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.ComprehensionExpression;
import org.sonar.python.api.tree.ComprehensionFor;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ComprehensionExpressionImpl
extends PyTree
implements ComprehensionExpression {
    private final Tree.Kind kind;
    private final Expression resultExpression;
    private final ComprehensionFor comprehensionFor;

    public ComprehensionExpressionImpl(Tree.Kind kind, Token openingToken, Expression resultExpression, ComprehensionFor compFor, Token closingToken) {
        super(openingToken, closingToken);
        this.kind = kind;
        this.resultExpression = resultExpression;
        this.comprehensionFor = compFor;
    }

    @Override
    public Expression resultExpression() {
        return this.resultExpression;
    }

    @Override
    public ComprehensionFor comprehensionFor() {
        return this.comprehensionFor;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPyListOrSetCompExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.resultExpression, this.comprehensionFor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }
}

