/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.ComprehensionClause;
import org.sonar.python.api.tree.ComprehensionFor;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ComprehensionForImpl
extends PyTree
implements ComprehensionFor {
    private final Token forToken;
    private final Expression loopExpression;
    private final Token inToken;
    private final Expression iterable;
    private final ComprehensionClause nested;

    public ComprehensionForImpl(AstNode node, Token forToken, Expression loopExpression, Token inToken, Expression iterable, @Nullable ComprehensionClause nested) {
        super(node);
        this.forToken = forToken;
        this.loopExpression = loopExpression;
        this.inToken = inToken;
        this.iterable = iterable;
        this.nested = nested;
    }

    @Override
    public Token forToken() {
        return this.forToken;
    }

    @Override
    public Expression loopExpression() {
        return this.loopExpression;
    }

    @Override
    public Token inToken() {
        return this.inToken;
    }

    @Override
    public Expression iterable() {
        return this.iterable;
    }

    @Override
    @CheckForNull
    public ComprehensionClause nestedClause() {
        return this.nested;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitComprehensionFor(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.forToken, this.loopExpression, this.inToken, this.iterable, this.nested).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.COMP_FOR;
    }
}

