/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.ConditionalExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ConditionalExpressionImpl
extends PyTree
implements ConditionalExpression {
    private final Expression trueExpression;
    private final Token ifToken;
    private final Expression condition;
    private final Token elseToken;
    private final Expression falseExpression;

    public ConditionalExpressionImpl(AstNode node, Expression trueExpression, Token ifToken, Expression condition, Token elseToken, Expression falseExpression) {
        super(node);
        this.trueExpression = trueExpression;
        this.ifToken = ifToken;
        this.condition = condition;
        this.elseToken = elseToken;
        this.falseExpression = falseExpression;
    }

    @Override
    public Token ifKeyword() {
        return this.ifToken;
    }

    @Override
    public Token elseKeyword() {
        return this.elseToken;
    }

    @Override
    public Expression trueExpression() {
        return this.trueExpression;
    }

    @Override
    public Expression falseExpression() {
        return this.falseExpression;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.ifToken, this.condition, this.trueExpression, this.elseToken, this.falseExpression).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPR;
    }
}

