/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.DelStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class DelStatementImpl
extends PyTree
implements DelStatement {
    private final Token delKeyword;
    private final List<Expression> expressionTrees;

    public DelStatementImpl(AstNode astNode, Token delKeyword, List<Expression> expressionTrees) {
        super(astNode);
        this.delKeyword = delKeyword;
        this.expressionTrees = expressionTrees;
    }

    @Override
    public Token delKeyword() {
        return this.delKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressionTrees;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DEL_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDelStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(Collections.singletonList(this.delKeyword), this.expressionTrees).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

