/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.ComprehensionFor;
import org.sonar.python.api.tree.DictCompExpression;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class DictCompExpressionImpl
extends PyTree
implements DictCompExpression {
    private final Expression keyExpression;
    private final Token colon;
    private final Expression valueExpression;
    private final ComprehensionFor comprehensionFor;

    public DictCompExpressionImpl(Token openingBrace, Expression keyExpression, Token colon, Expression valueExpression, ComprehensionFor compFor, Token closingBrace) {
        super(openingBrace, closingBrace);
        this.keyExpression = keyExpression;
        this.colon = colon;
        this.valueExpression = valueExpression;
        this.comprehensionFor = compFor;
    }

    @Override
    public Expression keyExpression() {
        return this.keyExpression;
    }

    @Override
    public Token colonToken() {
        return this.colon;
    }

    @Override
    public Expression valueExpression() {
        return this.valueExpression;
    }

    @Override
    public ComprehensionFor comprehensionFor() {
        return this.comprehensionFor;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDictCompExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.keyExpression, this.colon, this.valueExpression, this.comprehensionFor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DICT_COMPREHENSION;
    }
}

