/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.python.api.tree.EllipsisExpression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.TokenImpl;

public class EllipsisExpressionImpl
extends PyTree
implements EllipsisExpression {
    private final List<Token> ellipsis;

    public EllipsisExpressionImpl(AstNode node) {
        super(node);
        this.ellipsis = node.getTokens().stream().map(TokenImpl::new).collect(Collectors.toList());
    }

    @Override
    public List<Token> ellipsis() {
        return this.ellipsis;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitEllipsis(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.ellipsis);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ELLIPSIS;
    }
}

