/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.ElseStatement;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ElseStatementImpl
extends PyTree
implements ElseStatement {
    private final Token elseKeyword;
    private final StatementList body;

    public ElseStatementImpl(Token elseKeyword, StatementList body) {
        super(elseKeyword, body.lastToken());
        this.elseKeyword = elseKeyword;
        this.body = body;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ELSE_STMT;
    }

    @Override
    public Token elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitElseStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.elseKeyword, this.body).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

