/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.ExceptClause;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ExceptClauseImpl
extends PyTree
implements ExceptClause {
    private final Token exceptKeyword;
    private final StatementList body;
    private final Expression exception;
    private final Token asKeyword;
    private final Token commaToken;
    private final Expression exceptionInstance;

    public ExceptClauseImpl(Token exceptKeyword, StatementList body) {
        super(exceptKeyword, body.lastToken());
        this.exceptKeyword = exceptKeyword;
        this.body = body;
        this.exception = null;
        this.asKeyword = null;
        this.commaToken = null;
        this.exceptionInstance = null;
    }

    public ExceptClauseImpl(Token exceptKeyword, StatementList body, Expression exception, @Nullable Token asNode, @Nullable Token commaNode, Expression exceptionInstance) {
        super(exceptKeyword, body.lastToken());
        this.exceptKeyword = exceptKeyword;
        this.body = body;
        this.exception = exception;
        this.asKeyword = asNode;
        this.commaToken = commaNode;
        this.exceptionInstance = exceptionInstance;
    }

    public ExceptClauseImpl(Token exceptKeyword, StatementList body, Expression exception) {
        super(exceptKeyword, body.lastToken());
        this.exceptKeyword = exceptKeyword;
        this.body = body;
        this.exception = exception;
        this.asKeyword = null;
        this.commaToken = null;
        this.exceptionInstance = null;
    }

    @Override
    public Token exceptKeyword() {
        return this.exceptKeyword;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token asKeyword() {
        return this.asKeyword;
    }

    @Override
    @CheckForNull
    public Token commaToken() {
        return this.commaToken;
    }

    @Override
    @CheckForNull
    public Expression exception() {
        return this.exception;
    }

    @Override
    @CheckForNull
    public Expression exceptionInstance() {
        return this.exceptionInstance;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXCEPT_CLAUSE;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExceptClause(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.exceptKeyword, this.exception, this.asKeyword, this.exceptionInstance, this.commaToken, this.body).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

