/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.ExecStatement;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ExecStatementImpl
extends PyTree
implements ExecStatement {
    private final Token execKeyword;
    private final Expression expression;
    private final Expression globalsExpression;
    private final Expression localsExpression;

    public ExecStatementImpl(AstNode astNode, Token execKeyword, Expression expression, @Nullable Expression globalsExpression, @Nullable Expression localsExpression) {
        super(astNode);
        this.execKeyword = execKeyword;
        this.expression = expression;
        this.globalsExpression = globalsExpression;
        this.localsExpression = localsExpression;
    }

    public ExecStatementImpl(AstNode astNode, Token execKeyword, Expression expression) {
        super(astNode);
        this.execKeyword = execKeyword;
        this.expression = expression;
        this.globalsExpression = null;
        this.localsExpression = null;
    }

    @Override
    public Token execKeyword() {
        return this.execKeyword;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Expression globalsExpression() {
        return this.globalsExpression;
    }

    @Override
    public Expression localsExpression() {
        return this.localsExpression;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXEC_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExecStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.execKeyword, this.expression, this.globalsExpression, this.localsExpression).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

