/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.Collections;
import java.util.List;
import org.sonar.python.api.tree.Expression;
import org.sonar.python.api.tree.ExpressionList;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ExpressionListImpl
extends PyTree
implements ExpressionList {
    private final List<Expression> expressions;

    public ExpressionListImpl(AstNode astNode, List<Expression> expressions) {
        super(astNode);
        this.expressions = expressions;
    }

    public ExpressionListImpl(List<Expression> expressions) {
        super(expressions.get(0).firstToken(), expressions.get(expressions.size() - 1).lastToken());
        this.expressions = expressions;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXPRESSION_LIST;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitExpressionList(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.expressions);
    }
}

