/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.FileInput;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class FileInputImpl
extends PyTree
implements FileInput {
    private final StatementList statements;
    private final Token docstring;

    public FileInputImpl(AstNode astNode, @Nullable StatementList statements, Token docstring) {
        super(astNode);
        this.statements = statements;
        this.docstring = docstring;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FILE_INPUT;
    }

    @Override
    @CheckForNull
    public StatementList statements() {
        return this.statements;
    }

    @Override
    @CheckForNull
    public Token docstring() {
        return this.docstring;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFileInput(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.statements, this.docstring).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

