/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.python.api.tree.FinallyClause;
import org.sonar.python.api.tree.StatementList;
import org.sonar.python.api.tree.Token;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class FinallyClauseImpl
extends PyTree
implements FinallyClause {
    private final Token finallyKeyword;
    private final StatementList body;

    public FinallyClauseImpl(Token finallyKeyword, StatementList body) {
        super(finallyKeyword, body.lastToken());
        this.finallyKeyword = finallyKeyword;
        this.body = body;
    }

    @Override
    public Token finallyKeyword() {
        return this.finallyKeyword;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FINALLY_CLAUSE;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFinallyClause(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.finallyKeyword, this.body).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

